/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.RealmConfig;
import com.staxnet.appserver.config.ResourceConfig;
import com.staxnet.appserver.config.WebConfig;
import com.staxnet.appserver.utils.StringHelper;
import com.staxnet.appserver.utils.XmlHelper;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AppConfigParser {
    public void loadFromApplicationXml(AppConfig appConfig, InputStream is) {
        this.loadFromApplicationXml(appConfig, new InputSource(is));
    }

    public void loadFromApplicationXml(AppConfig appConfig, String file) {
        this.loadFromApplicationXml(appConfig, new InputSource(file));
    }

    public void load(AppConfig appConfig, Document doc, String[] environments, String[] implicitEnvironments) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            Element e = doc.getDocumentElement();
            this.applyToAppConfig(appConfig, xpath, e);
            appConfig.setDefaultEnvironment(e.getAttribute("default"));
            environments = environments == null || environments.length == 0 ? AppConfigParser.getEnvironmentList(appConfig.getDefaultEnvironment(), implicitEnvironments) : AppConfigParser.getEnvironmentList(StringHelper.join(environments, ","), implicitEnvironments);
            NodeList nodes = (NodeList)xpath.evaluate("environment", e, XPathConstants.NODESET);
            HashMap<String, Node> envNodes = new HashMap<String, Node>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                String envName = this.getAttribute(n, "name", null);
                if (envName == null) {
                    throw new IllegalArgumentException("missing required attribute (name) on environent element");
                }
                envNodes.put(envName, n);
            }
            if (environments != null) {
                for (String env : environments) {
                    Node n = (Node)envNodes.get(env);
                    if (n == null) continue;
                    this.applyToAppConfig(appConfig, xpath, n);
                    appConfig.getAppliedEnvironments().add(env);
                }
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void applyToAppConfig(AppConfig appConfig, XPath xpath, Node e) throws XPathExpressionException {
        Node node;
        int i;
        String name;
        String sessionDataSource;
        String appId = this.getNodeValue(e, xpath, "appid", true);
        if (appId != null) {
            appConfig.setApplicationId(appId);
        }
        if ((sessionDataSource = this.getNodeValue(e, xpath, "sessionDataSource", true)) != null) {
            appConfig.setSessionDataSource(sessionDataSource);
        }
        NodeList globalDepedencyNodes = (NodeList)xpath.evaluate("dependencies/dependency", e, XPathConstants.NODESET);
        for (int j = 0; j < globalDepedencyNodes.getLength(); ++j) {
            Node dependencyNode = globalDepedencyNodes.item(j);
            String org = this.getAttribute(dependencyNode, "org", null);
            name = this.getAttribute(dependencyNode, "name", null);
            String rev = this.getAttribute(dependencyNode, "rev", null);
            appConfig.getDependencies().add(new DependencyConfig(org, name, rev));
        }
        NodeList nodes = (NodeList)xpath.evaluate("web", e, XPathConstants.NODESET);
        for (i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            String weburi = this.getNodeValue(node, xpath, "web-uri", true);
            String contextPath = this.getNodeValue(node, xpath, "context-root", true);
            if (contextPath != null && !contextPath.equals("") && !contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            WebConfig wc = this.getOrCreateWebConfig(appConfig, contextPath);
            if (weburi != null) {
                wc.setWebUri(weburi);
            }
            NodeList paramNodes = (NodeList)xpath.evaluate("context-param", node, XPathConstants.NODESET);
            for (int j = 0; j < paramNodes.getLength(); ++j) {
                Node paramNode = paramNodes.item(j);
                String paramName = this.getNodeValue(paramNode, xpath, "param-name", true);
                String paramValue = this.getNodeValue(paramNode, xpath, "param-value", true);
                String description = this.getNodeValue(paramNode, xpath, "description", true);
                wc.setParameter(paramName, paramValue, description);
            }
            NodeList depedencyNodes = (NodeList)xpath.evaluate("dependencies/dependency", node, XPathConstants.NODESET);
            for (int j = 0; j < depedencyNodes.getLength(); ++j) {
                Node dependencyNode = depedencyNodes.item(j);
                String org = this.getAttribute(dependencyNode, "org", null);
                String name2 = this.getAttribute(dependencyNode, "name", null);
                String rev = this.getAttribute(dependencyNode, "rev", null);
                wc.getDependencies().add(new DependencyConfig(org, name2, rev));
            }
            NodeList syspropNodes = (NodeList)xpath.evaluate("sysprop", node, XPathConstants.NODESET);
            for (int j = 0; j < syspropNodes.getLength(); ++j) {
                Node syspropNode = syspropNodes.item(j);
                String paramName = this.getAttribute(syspropNode, "name", null);
                String paramValue = this.getAttribute(syspropNode, "value", null);
                ResourceConfig resource = new ResourceConfig(paramName, paramValue, "system-property");
                appConfig.addOrUpdateResource(resource);
            }
        }
        nodes = (NodeList)xpath.evaluate("resource", e, XPathConstants.NODESET);
        for (i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            name = this.getAttribute(node, "name", null);
            ResourceConfig resource = new ResourceConfig(name);
            resource.setAuth(this.getAttribute(node, "auth", null));
            resource.setType(this.getAttribute(node, "type", null));
            resource.setDelim(this.getAttribute(node, "delim", null));
            resource.setValue(this.getAttribute(node, "value", null));
            resource.setScope(this.getAttribute(node, "scope", null));
            NodeList paramNodes = (NodeList)xpath.evaluate("param", node, XPathConstants.NODESET);
            for (int paramIndex = 0; paramIndex < paramNodes.getLength(); ++paramIndex) {
                Node paramNode = paramNodes.item(paramIndex);
                String paramName = this.getAttribute(paramNode, "name", null);
                String paramValue = this.getAttribute(paramNode, "value", null);
                resource.setParameter(paramName, paramValue);
            }
            appConfig.addOrUpdateResource(resource);
        }
        nodes = (NodeList)xpath.evaluate("realm", e, XPathConstants.NODESET);
        if (nodes.getLength() > 1) {
            throw new IllegalArgumentException("Multiple realms cannot be declared");
        }
        if (nodes.getLength() == 1) {
            Node node2 = nodes.item(0);
            RealmConfig realm = new RealmConfig();
            NodeList paramNodes = (NodeList)xpath.evaluate("param", node2, XPathConstants.NODESET);
            for (int paramIndex = 0; paramIndex < paramNodes.getLength(); ++paramIndex) {
                Node paramNode = paramNodes.item(paramIndex);
                String paramName = this.getAttribute(paramNode, "name", null);
                String paramValue = this.getAttribute(paramNode, "value", null);
                realm.setParameter(paramName, paramValue);
            }
            appConfig.setRealm(realm);
        }
    }

    private void loadFromApplicationXml(AppConfig appConfig, InputSource input) {
        Document doc = XmlHelper.readXML(input);
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            Element e = doc.getDocumentElement();
            NodeList nodes = (NodeList)xpath.evaluate("module/web", e, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String weburi = this.getNodeValue(node, xpath, "web-uri", true);
                String contextPath = this.getNodeValue(node, xpath, "context-root", true);
                if (contextPath != null && !contextPath.equals("") && !contextPath.startsWith("/")) {
                    contextPath = "/" + contextPath;
                }
                WebConfig wc = this.getOrCreateWebConfig(appConfig, contextPath);
                wc.setWebUri(weburi);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private String getAttribute(Node node, String attr, String defaultValue) {
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode == null) {
            return defaultValue;
        }
        return attrNode.getNodeValue();
    }

    private String getNodeValue(Node node, XPath xpath, String expression, boolean trim) throws XPathExpressionException {
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        if (n == null) {
            return null;
        }
        String nodeValue = xpath.evaluate("text()", n);
        return nodeValue.trim();
    }

    private WebConfig getOrCreateWebConfig(AppConfig appConfig, String contextPath) {
        WebConfig wc = appConfig.getWebConfig(contextPath);
        if (wc == null) {
            wc = new WebConfig(contextPath);
            appConfig.getWebConfigs().add(wc);
        }
        return wc;
    }

    public static String[] getEnvironmentList(String environments, String ... prependEnvs) {
        int i;
        if (environments == null && prependEnvs.length == 0) {
            return new String[0];
        }
        if (environments == null) {
            environments = "";
        }
        String[] envSplit = environments.split(",");
        String[] envList = new String[envSplit.length + prependEnvs.length];
        for (i = 0; i < prependEnvs.length; ++i) {
            envList[i] = prependEnvs[i];
        }
        for (i = 0; i < envSplit.length; ++i) {
            envList[prependEnvs.length + i] = envSplit[i].trim();
        }
        return envList;
    }
}

