/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver.config;

import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppConfigParser;
import com.staxnet.appserver.config.WebAppConfigParser;
import com.staxnet.appserver.config.WebConfig;
import com.staxnet.appserver.utils.XmlHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class AppConfigHelper {
    public static void load(AppConfig appConfig, String appConfigFile, String[] environments, String[] implicitEnvironments) {
        if (appConfigFile != null && new File(appConfigFile).exists()) {
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(appConfigFile));
                InputSource input = new InputSource(inputStream);
                AppConfigHelper.load(appConfig, input, appConfigFile, environments, implicitEnvironments);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("File does not exist: " + appConfigFile);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void load(AppConfig appConfig, InputStream in, String configFilePath, String[] environments, String[] implicitEnvironments) {
        InputSource input = new InputSource(in);
        AppConfigHelper.load(appConfig, input, configFilePath, environments, implicitEnvironments);
    }

    private static void load(AppConfig appConfig, InputSource input, String configFilePath, String[] environments, String[] implicitEnvironments) {
        Document doc = XmlHelper.readXML(input);
        Element rootElement = doc.getDocumentElement();
        if (rootElement.getNodeName().equals("stax-application")) {
            AppConfigParser parser = new AppConfigParser();
            parser.load(appConfig, doc, environments, implicitEnvironments);
        } else if (rootElement.getNodeName().equals("stax-web-app") || rootElement.getNodeName().equals("cloudbees-web-app")) {
            String webrootPath = null;
            if (configFilePath != null) {
                File configFile = new File(configFilePath);
                File webRoot = configFile.getParentFile().getParentFile();
                webrootPath = webRoot.getAbsolutePath();
            }
            WebAppConfigParser parser = new WebAppConfigParser("", webrootPath);
            parser.load(appConfig, doc, environments, implicitEnvironments);
        }
    }

    private static WebConfig getOrCreateWebConfig(AppConfig appConfig, String contextPath) {
        WebConfig wc = appConfig.getWebConfig(contextPath);
        if (wc == null) {
            wc = new WebConfig(contextPath);
            appConfig.getWebConfigs().add(wc);
        }
        return wc;
    }
}

