/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxAppServerCLI {
    private Options options;
    private CommandLine commandLine;
    private String baseDir;
    private int port;
    private String[] environment = new String[0];
    private boolean fetchModulesOnly;
    private String installZipFile;
    private String serverConfigPath;
    private String repositoryPath;
    List<String> missingOptions = new ArrayList<String>();

    private StaxAppServerCLI(CommandLine commandLine, Options options) throws ParseException {
        this.commandLine = commandLine;
        this.options = options;
        this.baseDir = this.getRequiredOption("dir", this.missingOptions);
        this.port = this.getIntOption("port", 8080);
        this.installZipFile = this.getOption("install", null);
        this.serverConfigPath = this.getOption("config", null);
        this.fetchModulesOnly = commandLine.hasOption("prepareForRun");
        this.repositoryPath = this.getOption("repository", null);
        String envArg = this.getOption("env", null);
        ArrayList<String> envList = new ArrayList<String>();
        if (envArg != null) {
            this.environment = envArg.split(",");
            for (int i = 0; i < this.environment.length; ++i) {
                String env = this.environment[i].trim();
                if (env.length() <= 0) continue;
                envList.add(env);
            }
            this.environment = envList.toArray(new String[0]);
        }
    }

    private String getOption(String optionName, String defaultValue) {
        if (this.commandLine.hasOption(optionName)) {
            return this.commandLine.getOptionValue(optionName);
        }
        return defaultValue;
    }

    private String getRequiredOption(String optionName, List<String> missingOptions) {
        if (this.commandLine.hasOption(optionName)) {
            return this.commandLine.getOptionValue(optionName);
        }
        missingOptions.add(optionName);
        return null;
    }

    private int getIntOption(String optionName, int defaultValue) throws ParseException {
        if (this.commandLine.hasOption(optionName)) {
            try {
                return Integer.parseInt(this.commandLine.getOptionValue(optionName));
            }
            catch (NumberFormatException e) {
                throw new ParseException("option " + optionName + " mus be a numeric value");
            }
        }
        return defaultValue;
    }

    public static StaxAppServerCLI parse(String[] args) throws ParseException {
        Option help = new Option("help", "print this message");
        OptionBuilder.withArgName((String)"install");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"application zip file");
        Option install = OptionBuilder.create((String)"install");
        OptionBuilder.withArgName((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"working directory");
        Option dir = OptionBuilder.create((String)"dir");
        OptionBuilder.withArgName((String)"httpPort");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"server port to listen on");
        Option port = OptionBuilder.create((String)"port");
        OptionBuilder.withArgName((String)"environment");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"additional environment configurations");
        Option environment = OptionBuilder.create((String)"env");
        OptionBuilder.withArgName((String)"config");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"server configuration file");
        Option config = OptionBuilder.create((String)"config");
        Option fetchModulesOnly = new Option("fetchModulesOnly", "downloads application dependencies without starting the server");
        OptionBuilder.withArgName((String)"repository");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"module repository directory");
        Option repository = OptionBuilder.create((String)"repository");
        Options options = new Options();
        options.addOption(help);
        options.addOption(install);
        options.addOption(dir);
        options.addOption(port);
        options.addOption(environment);
        options.addOption(config);
        options.addOption(fetchModulesOnly);
        options.addOption(repository);
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(options, args);
        return new StaxAppServerCLI(commandLine, options);
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("appserver", this.options);
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getInstallZipFile() {
        return this.installZipFile;
    }

    public boolean getFetchModulesOnly() {
        return this.fetchModulesOnly;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public File getServerConfigFile() {
        if (this.serverConfigPath != null) {
            return new File(this.serverConfigPath);
        }
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getEnvironment() {
        return this.environment;
    }

    public String formatMissingOptions(String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.missingOptions.size(); ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(this.missingOptions.get(i));
        }
        return sb.toString();
    }

    public String[] getMissingOptions() {
        return this.missingOptions.toArray(new String[0]);
    }
}

