/*
 * Decompiled with CFR 0.152.
 */
package com.staxnet.appserver;

import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.config.AppConfig;
import com.staxnet.appserver.config.AppConfigHelper;
import com.staxnet.appserver.config.AppConfigParser;
import com.staxnet.appserver.config.WebConfig;
import com.staxnet.appserver.utils.AppServerConfiguration;
import java.io.File;
import java.util.logging.Logger;

public class EarBasedServerConfiguration
extends AppServerConfiguration {
    protected static Logger logger = Logger.getLogger(EarBasedServerConfiguration.class.getName());

    private EarBasedServerConfiguration() {
    }

    public static IAppServerConfiguration load(File serverXmlFile, File staxAppXmlFile, File j2eeAppXmlFile, String[] environments) {
        EarBasedServerConfiguration appserverConfig;
        EarBasedServerConfiguration earBasedServerConfiguration = appserverConfig = new EarBasedServerConfiguration();
        earBasedServerConfiguration.getClass();
        AppServerConfigurationLoader loader = earBasedServerConfiguration.new AppServerConfigurationLoader(appserverConfig);
        if (j2eeAppXmlFile == null || !j2eeAppXmlFile.exists()) {
            loader.loadV1(serverXmlFile, staxAppXmlFile, environments);
        } else {
            loader.loadV2(serverXmlFile, staxAppXmlFile, j2eeAppXmlFile, environments);
        }
        appserverConfig.mergeResources();
        return appserverConfig;
    }

    private class AppServerConfigurationLoader {
        private EarBasedServerConfiguration appserverConfig;

        public AppServerConfigurationLoader(EarBasedServerConfiguration appserverConfig) {
            this.appserverConfig = appserverConfig;
        }

        public void loadV1(File serverXmlFile, File staxAppXmlFile, String[] environments) {
            this.loadV2(serverXmlFile, staxAppXmlFile, null, environments);
            for (int i = 0; i < environments.length; ++i) {
                WebConfig config;
                if (!environments[i].equals("run") || (config = this.appserverConfig.appConfig.getWebConfigs().get(0)).getWebUri() != null) continue;
                config.setWebUri("/webapp");
            }
        }

        public void loadV2(File serverXmlFile, File staxAppXmlFile, File j2eeAppXmlFile, String[] environments) {
            this.appserverConfig.appConfig = new AppConfig();
            if (j2eeAppXmlFile != null && j2eeAppXmlFile.exists()) {
                new AppConfigParser().loadFromApplicationXml(this.appserverConfig.appConfig, j2eeAppXmlFile.getAbsolutePath());
            }
            if (staxAppXmlFile != null && staxAppXmlFile.exists()) {
                AppConfigHelper.load(this.appserverConfig.appConfig, staxAppXmlFile.getAbsolutePath(), environments, new String[0]);
            }
            this.appserverConfig.readAppServerConfig(serverXmlFile);
        }
    }
}

