/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.auth;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.compat.SpyThread;
import net.spy.memcached.compat.log.Level;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.SASLMechsOperation;

public class AuthThread
extends SpyThread {
    public static final int AUTH_ROUNDTRIP_THRESHOLD = 250;
    public static final int AUTH_TOTAL_THRESHOLD = 1000;
    public static final String MECH_SEPARATOR = " ";
    private final MemcachedConnection conn;
    private final AuthDescriptor authDescriptor;
    private final OperationFactory opFact;
    private final MemcachedNode node;

    public AuthThread(MemcachedConnection c, OperationFactory o, AuthDescriptor a, MemcachedNode n) {
        this.conn = c;
        this.opFact = o;
        this.authDescriptor = a;
        this.node = n;
        this.start();
    }

    protected String[] listSupportedSASLMechanisms(AtomicBoolean done) {
        final CountDownLatch listMechsLatch = new CountDownLatch(1);
        final AtomicReference supportedMechs = new AtomicReference();
        SASLMechsOperation listMechsOp = this.opFact.saslMechs(new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                if (status.isSuccess()) {
                    supportedMechs.set(status.getMessage());
                    AuthThread.this.getLogger().debug("Received SASL supported mechs: " + status.getMessage());
                }
            }

            @Override
            public void complete() {
                listMechsLatch.countDown();
            }
        });
        this.conn.insertOperation(this.node, listMechsOp);
        try {
            if (!this.conn.isShutDown()) {
                listMechsLatch.await();
            } else {
                done.set(true);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            if (listMechsOp != null) {
                listMechsOp.cancel();
            }
            done.set(true);
        }
        String supported = (String)supportedMechs.get();
        if (supported == null || supported.isEmpty()) {
            throw new IllegalStateException("Got empty SASL auth mech list.");
        }
        return supported.split(MECH_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final AtomicBoolean done = new AtomicBoolean();
        long totalStart = System.nanoTime();
        long mechsStart = System.nanoTime();
        String[] supportedMechs = this.authDescriptor.getMechs() == null || this.authDescriptor.getMechs().length == 0 ? this.listSupportedSASLMechanisms(done) : this.authDescriptor.getMechs();
        long mechsDiff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - mechsStart);
        String msg = String.format("SASL List Mechanisms took %dms on %s", mechsDiff, this.node.toString());
        Level level = mechsDiff >= 250L ? Level.WARN : Level.DEBUG;
        this.getLogger().log(level, msg);
        OperationStatus priorStatus = null;
        while (!done.get()) {
            long stepDiff;
            long stepStart = System.nanoTime();
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference foundStatus = new AtomicReference();
            OperationCallback cb = new OperationCallback(){

                @Override
                public void receivedStatus(OperationStatus val) {
                    if (val.getMessage().length() == 0) {
                        done.set(true);
                        AuthThread.this.node.authComplete();
                        AuthThread.this.getLogger().info("Authenticated to " + AuthThread.this.node.getSocketAddress());
                    } else {
                        foundStatus.set(val);
                    }
                }

                @Override
                public void complete() {
                    latch.countDown();
                }
            };
            Operation op = this.buildOperation(priorStatus, cb, supportedMechs);
            this.conn.insertOperation(this.node, op);
            try {
                if (!this.conn.isShutDown()) {
                    latch.await();
                } else {
                    done.set(true);
                }
                Thread.sleep(100L);
                stepDiff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stepStart);
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    if (op != null) {
                        op.cancel();
                    }
                    done.set(true);
                    stepDiff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stepStart);
                }
                catch (Throwable throwable) {
                    long stepDiff2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stepStart);
                    msg = String.format("SASL Step took %dms on %s", stepDiff2, this.node.toString());
                    level = mechsDiff >= 250L ? Level.WARN : Level.DEBUG;
                    this.getLogger().log(level, msg);
                    throw throwable;
                }
                msg = String.format("SASL Step took %dms on %s", stepDiff, this.node.toString());
                level = mechsDiff >= 250L ? Level.WARN : Level.DEBUG;
                this.getLogger().log(level, msg);
            }
            msg = String.format("SASL Step took %dms on %s", stepDiff, this.node.toString());
            level = mechsDiff >= 250L ? Level.WARN : Level.DEBUG;
            this.getLogger().log(level, msg);
            if ((priorStatus = (OperationStatus)foundStatus.get()) == null || priorStatus.isSuccess()) continue;
            this.getLogger().warn("Authentication failed to " + this.node.getSocketAddress());
        }
        long totalDiff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - totalStart);
        msg = String.format("SASL Auth took %dms on %s", totalDiff, this.node.toString());
        level = mechsDiff >= 1000L ? Level.WARN : Level.DEBUG;
        this.getLogger().log(level, msg);
    }

    private Operation buildOperation(OperationStatus st, OperationCallback cb, String[] supportedMechs) {
        if (st == null) {
            return this.opFact.saslAuth(supportedMechs, this.node.getSocketAddress().toString(), null, this.authDescriptor.getCallback(), cb);
        }
        return this.opFact.saslStep(supportedMechs, KeyUtil.getKeyBytes(st.getMessage()), this.node.getSocketAddress().toString(), null, this.authDescriptor.getCallback(), cb);
    }
}

