/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.tapmessage;

import java.nio.ByteBuffer;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.tapmessage.TapMagic;
import net.spy.memcached.tapmessage.TapOpcode;
import net.spy.memcached.tapmessage.Util;

public class BaseMessage
extends SpyObject {
    public static final int MAGIC_INDEX = 0;
    public static final int MAGIC_FIELD_LENGTH = 1;
    public static final int OPCODE_INDEX = 1;
    public static final int OPCODE_FIELD_LENGTH = 1;
    public static final int KEY_LENGTH_INDEX = 2;
    public static final int KEY_LENGTH_FIELD_LENGTH = 2;
    public static final int EXTRA_LENGTH_INDEX = 4;
    public static final int EXTRA_LENGTH_FIELD_LENGTH = 1;
    public static final int DATA_TYPE_INDEX = 5;
    public static final int DATA_TYPE_FIELD_LENGTH = 1;
    public static final int VBUCKET_INDEX = 6;
    public static final int VBUCKET_FIELD_LENGTH = 2;
    public static final int TOTAL_BODY_INDEX = 8;
    public static final int TOTAL_BODY_FIELD_LENGTH = 4;
    public static final int OPAQUE_INDEX = 12;
    public static final int OPAQUE_FIELD_LENGTH = 4;
    public static final int CAS_INDEX = 16;
    public static final int CAS_FIELD_LENGTH = 8;
    public static final int HEADER_LENGTH = 24;
    protected byte[] mbytes = new byte[24];

    protected BaseMessage() {
    }

    public final void setMagic(TapMagic m) {
        this.mbytes[0] = m.getMagic();
    }

    public final int getMagic() {
        return this.mbytes[0];
    }

    public final void setOpcode(TapOpcode o) {
        this.mbytes[1] = o.getOpcode();
    }

    public final TapOpcode getOpcode() {
        return TapOpcode.getOpcodeByByte(this.mbytes[1]);
    }

    protected final void setKeylength(long l) {
        Util.valueToFieldOffest(this.mbytes, 2, 2, l);
    }

    public final int getKeylength() {
        return (int)Util.fieldToValue(this.mbytes, 2, 2);
    }

    public final void setDatatype(byte b) {
        this.mbytes[5] = b;
    }

    public final byte getDatatype() {
        return this.mbytes[5];
    }

    public final void setExtralength(int i) {
        this.mbytes[4] = (byte)i;
    }

    public final int getExtralength() {
        return this.mbytes[4];
    }

    public final void setVbucket(int vb) {
        Util.valueToFieldOffest(this.mbytes, 6, 2, vb);
    }

    public final int getVbucket() {
        return (int)Util.fieldToValue(this.mbytes, 6, 2);
    }

    public final void setTotalbody(long l) {
        Util.valueToFieldOffest(this.mbytes, 8, 4, l);
    }

    public final int getTotalbody() {
        return (int)Util.fieldToValue(this.mbytes, 8, 4);
    }

    public final void setOpaque(int op) {
        Util.valueToFieldOffest(this.mbytes, 12, 4, op);
    }

    public final int getOpaque() {
        return (int)Util.fieldToValue(this.mbytes, 12, 4);
    }

    public final void setCas(long cas) {
        Util.valueToFieldOffest(this.mbytes, 16, 8, cas);
    }

    public final long getCas() {
        return Util.fieldToValue(this.mbytes, 16, 8);
    }

    public final int getMessageLength() {
        return 24 + this.getTotalbody();
    }

    public final ByteBuffer getBytes() {
        return ByteBuffer.wrap(this.mbytes);
    }
}

