/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.couch;

import java.io.IOException;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.couch.HttpOperation;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class HttpOperationImpl
implements HttpOperation {
    private final HttpRequest request;
    protected final OperationCallback callback;
    protected OperationException exception;
    private boolean cancelled;
    private boolean errored;
    private boolean timedOut;

    public HttpOperationImpl(HttpRequest r, OperationCallback cb) {
        this.request = r;
        this.callback = cb;
        this.exception = null;
        this.cancelled = false;
        this.errored = false;
        this.timedOut = false;
    }

    @Override
    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    public OperationCallback getCallback() {
        return this.callback;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean hasErrored() {
        return this.errored;
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void timeOut() {
        this.timedOut = true;
    }

    @Override
    public OperationException getException() {
        return this.exception;
    }

    @Override
    public abstract void handleResponse(HttpResponse var1);

    protected String getEntityString(HttpResponse response) {
        if (!(this.isTimedOut() || this.hasErrored() || this.isCancelled())) {
            try {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (ParseException e) {
                this.exception = new OperationException(OperationErrorType.GENERAL, "Bad http headers");
                this.errored = true;
            }
            catch (IOException e) {
                this.exception = new OperationException(OperationErrorType.GENERAL, "Error reading response");
                this.errored = true;
            }
            catch (IllegalArgumentException e) {
                this.exception = new OperationException(OperationErrorType.GENERAL, "No entity");
                this.errored = true;
            }
        }
        return null;
    }

    protected OperationStatus parseViewForStatus(String json, int errorcode) throws java.text.ParseException {
        if (json != null) {
            try {
                JSONObject base = new JSONObject(json);
                if (base.has("error")) {
                    String error = "Error Code: " + errorcode + " Error: " + base.getString("error");
                    if (base.has("reason")) {
                        error = error + " Reason: " + base.getString("reason");
                    }
                    return new OperationStatus(false, error);
                }
                return new OperationStatus(true, "Error Code: " + errorcode);
            }
            catch (JSONException e) {
                throw new java.text.ParseException("Cannot read json: " + json, 0);
            }
        }
        return new OperationStatus(false, "Error Code: " + errorcode + "No entity");
    }
}

