/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.TapOperation;
import net.spy.memcached.protocol.binary.OperationImpl;
import net.spy.memcached.tapmessage.ResponseMessage;
import net.spy.memcached.tapmessage.TapOpcode;
import net.spy.memcached.tapmessage.Util;

public abstract class TapOperationImpl
extends OperationImpl
implements TapOperation {
    private static final byte TAP_FLAG_ACK = 1;
    private int bytesProcessed;
    private int bodylen;
    private byte[] header = new byte[24];
    private byte[] message = null;
    static final byte CMD = 0;

    protected TapOperationImpl(OperationCallback cb) {
        super((byte)0, TapOperationImpl.generateOpaque(), cb);
    }

    @Override
    public abstract void initialize();

    @Override
    public void readFromBuffer(ByteBuffer data) throws IOException {
        while (data.remaining() > 0) {
            if (this.bytesProcessed < 24) {
                this.header[this.bytesProcessed] = data.get();
                ++this.bytesProcessed;
                continue;
            }
            if (this.message == null) {
                this.bodylen = (int)Util.fieldToValue(this.header, 8, 4);
                this.message = new byte[24 + this.bodylen];
                System.arraycopy(this.header, 0, this.message, 0, 24);
            }
            if (this.bytesProcessed < this.message.length) {
                this.message[this.bytesProcessed] = data.get();
                ++this.bytesProcessed;
            }
            if (this.bytesProcessed < this.message.length) continue;
            ResponseMessage response = new ResponseMessage(this.message);
            if (response.getFlags() == 1) {
                ((TapOperation.Callback)this.getCallback()).gotAck(response.getOpcode(), response.getOpaque());
            }
            if (response.getOpcode() != TapOpcode.OPAQUE && response.getOpcode() != TapOpcode.NOOP) {
                ((TapOperation.Callback)this.getCallback()).gotData(response);
            }
            this.message = null;
            this.bytesProcessed = 0;
        }
    }
}

