/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class TclIndex
implements InternalRep {
    private int index;
    private String[] table;

    private TclIndex(int i, String[] tab) {
        this.index = i;
        this.table = tab;
    }

    public InternalRep duplicate() {
        return new TclIndex(this.index, this.table);
    }

    public void dispose() {
    }

    public String toString() {
        return this.table[this.index];
    }

    public static int get(Interp interp, TclObject tobj, String[] table, String msg, int flags) throws TclException {
        int index;
        block10: {
            InternalRep rep = tobj.getInternalRep();
            if (rep instanceof TclIndex && ((TclIndex)rep).table == table) {
                return ((TclIndex)rep).index;
            }
            String str = tobj.toString();
            int strLen = str.length();
            int tableLen = table.length;
            index = -1;
            int numAbbrev = 0;
            if (strLen > 0) {
                for (int i = 0; i < tableLen; ++i) {
                    String option = table[i];
                    if ((flags & 1) == 1 && option.length() != strLen) continue;
                    if (option.equals(str)) {
                        index = i;
                        break block10;
                    }
                    if (!option.startsWith(str)) continue;
                    ++numAbbrev;
                    index = i;
                }
            }
            if (numAbbrev != 1) {
                StringBuffer sbuf = new StringBuffer();
                if (numAbbrev > 1) {
                    sbuf.append("ambiguous ");
                } else {
                    sbuf.append("bad ");
                }
                sbuf.append(msg);
                sbuf.append(" \"");
                sbuf.append(str);
                sbuf.append("\"");
                sbuf.append(": must be ");
                sbuf.append(table[0]);
                for (int i = 1; i < tableLen; ++i) {
                    if (i == tableLen - 1) {
                        sbuf.append(i > 1 ? ", or " : " or ");
                    } else {
                        sbuf.append(", ");
                    }
                    sbuf.append(table[i]);
                }
                throw new TclException(interp, sbuf.toString());
            }
        }
        tobj.setInternalRep((InternalRep)new TclIndex(index, table));
        return index;
    }

    void testUpdateIndex(int index) {
        this.index = index;
    }
}

