/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.JavaInvoke;
import tcl.lang.PackageNameException;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

public class JavaImportCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        ArrayList<String> class_list;
        String class_package;
        ListIterator iter;
        boolean debug = false;
        String usage = "java::import ?-forget? ?-package pkg? ?class ...?";
        HashMap classTable = interp.importTable[0];
        HashMap packageTable = interp.importTable[1];
        boolean forget = false;
        String pkg = null;
        if (objv.length == 1) {
            TclObject import_list = TclList.newInstance();
            Iterator iter2 = classTable.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                TclList.append((Interp)interp, (TclObject)import_list, (TclObject)TclString.newInstance(value));
            }
            interp.setResult(import_list);
            return;
        }
        int startIdx = 1;
        String elem = objv[startIdx].toString();
        if (elem.equals("-forget")) {
            forget = true;
            ++startIdx;
        }
        if (startIdx >= objv.length) {
            interp.resetResult();
            return;
        }
        elem = objv[startIdx].toString();
        if (elem.equals("-package")) {
            if (++startIdx >= objv.length) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            pkg = objv[startIdx].toString();
            if (pkg.length() == 0) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            ++startIdx;
        }
        if (startIdx >= objv.length) {
            if (forget) {
                if (pkg == null) {
                    throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
                }
                boolean found = false;
                Iterator iter3 = packageTable.entrySet().iterator();
                while (iter3.hasNext()) {
                    Map.Entry entry = iter3.next();
                    elem = (String)entry.getKey();
                    if (!elem.equals(pkg)) continue;
                    if (found) {
                        throw new TclRuntimeError("unexpected : found == true");
                    }
                    found = true;
                    ArrayList alist = (ArrayList)entry.getValue();
                    ListIterator iter2 = alist.listIterator();
                    while (iter2.hasNext()) {
                        String elem2 = (String)iter2.next();
                        if (classTable.remove(elem2) != null) continue;
                        throw new TclRuntimeError("key " + elem2 + " not in classTable");
                    }
                    if (packageTable.remove(elem) != null) continue;
                    throw new TclRuntimeError("key " + elem + " not in packageTable");
                }
                if (!found) {
                    throw new TclException(interp, "cannot forget package \"" + pkg + "\", no classes were imported from it");
                }
                interp.resetResult();
                return;
            }
            if (pkg == null) {
                throw new TclRuntimeError("unexpected : pkg == null");
            }
            Iterator iter4 = packageTable.entrySet().iterator();
            while (iter4.hasNext()) {
                Map.Entry entry = iter4.next();
                elem = (String)entry.getKey();
                if (!elem.equals(pkg)) continue;
                TclObject import_list = TclList.newInstance();
                ArrayList alist = (ArrayList)entry.getValue();
                ListIterator iter2 = alist.listIterator();
                while (iter2.hasNext()) {
                    String elem2 = (String)iter2.next();
                    TclList.append((Interp)interp, (TclObject)import_list, (TclObject)TclString.newInstance((String)classTable.get(elem2)));
                }
                interp.setResult(import_list);
                return;
            }
            interp.resetResult();
            return;
        }
        ArrayList<String> importClasses = new ArrayList<String>();
        ArrayList<String> forgetClasses = new ArrayList<String>();
        String operation = "import";
        if (forget) {
            operation = "forget";
        }
        TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
        for (int i = startIdx; i < objv.length; ++i) {
            elem = objv[i].toString();
            if (elem.length() == 0 || elem.equals("-forget") || elem.equals("-package")) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            if (pkg != null && elem.indexOf(46) != -1) {
                throw new TclException(interp, "class argument must not contain a package specifier when the -package pkg arguments are given");
            }
            if (elem.equals("int") || elem.equals("boolean") || elem.equals("long") || elem.equals("float") || elem.equals("double") || elem.equals("byte") || elem.equals("short") || elem.equals("char")) {
                throw new TclException(interp, "cannot " + operation + " primitive type \"" + elem + "\"");
            }
            String fullyqualified = pkg == null ? elem : pkg + "." + elem;
            int ind = fullyqualified.lastIndexOf(46);
            if (ind == -1) {
                throw new TclException(interp, "cannot " + operation + " from global package");
            }
            String class_package2 = fullyqualified.substring(0, ind);
            String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
            if (class_package2.equals("java.lang")) {
                throw new TclException(interp, "cannot " + operation + " class \"" + fullyqualified + "\", it is in the java.lang package");
            }
            if (!forget) {
                boolean inGlobal = true;
                try {
                    tclClassLoader.loadClass(class_name);
                }
                catch (ClassNotFoundException e) {
                    inGlobal = false;
                }
                catch (PackageNameException e) {
                    throw e;
                }
                if (inGlobal) {
                    tclClassLoader.removeCache(class_name);
                    throw new TclException(interp, "cannot import \"" + fullyqualified + "\" it conflicts with a class with the same name" + " in the global package");
                }
                Class c = null;
                try {
                    c = tclClassLoader.loadClass(fullyqualified);
                    if (!PkgInvoker.isAccessible(c)) {
                        JavaInvoke.notAccessibleError(interp, c);
                    }
                    if (JavaInvoke.isInnerClass(c)) {
                        throw new TclException(interp, "can't import an inner class");
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (PackageNameException e) {
                    // empty catch block
                }
                if (c == null) {
                    Class inner = null;
                    try {
                        inner = JavaInvoke.getClassByName(interp, fullyqualified);
                    }
                    catch (TclException e2) {
                        // empty catch block
                    }
                    if (inner != null && JavaInvoke.isInnerClass(inner)) {
                        throw new TclException(interp, "can't import an inner class");
                    }
                    throw new TclException(interp, "cannot import class \"" + fullyqualified + "\", it does not exist");
                }
            }
            if (forget && classTable.get(class_name) == null) {
                throw new TclException(interp, "cannot forget class \"" + fullyqualified + "\", it was never imported");
            }
            if (forget) {
                forgetClasses.add(fullyqualified);
                continue;
            }
            importClasses.add(fullyqualified);
        }
        if (forgetClasses.size() != 0 && importClasses.size() != 0) {
            throw new TclRuntimeError("unexpected : forgetClasses and importClasses are both nonempty");
        }
        if (forgetClasses.size() != 0) {
            iter = forgetClasses.listIterator();
            while (iter.hasNext()) {
                String fullyqualified = (String)iter.next();
                int ind = fullyqualified.lastIndexOf(46);
                if (ind == -1) {
                    throw new TclRuntimeError("unexpected : no package in forget class");
                }
                class_package = fullyqualified.substring(0, ind);
                String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
                class_list = (ArrayList<String>)packageTable.get(class_package);
                int cindex = class_list.indexOf(class_name);
                if (cindex == -1) {
                    throw new TclRuntimeError("unexpected : class not found in package list");
                }
                if (class_list.remove(cindex) == null) {
                    throw new TclRuntimeError("could not remove element at index " + cindex + " from {" + class_list + "}, class_name is " + class_name);
                }
                if (class_list.size() == 0 && packageTable.remove(class_package) == null) {
                    throw new TclRuntimeError("could not remove " + class_package + " from packageTable");
                }
                if (classTable.remove(class_name) != null) continue;
                throw new TclRuntimeError("could not remove " + class_name + " from classTable");
            }
        }
        if (importClasses.size() != 0) {
            iter = importClasses.listIterator();
            while (iter.hasNext()) {
                String fullyqualified = (String)iter.next();
                int ind = fullyqualified.lastIndexOf(46);
                if (ind == -1) {
                    throw new TclRuntimeError("unexpected : no package in import class");
                }
                class_package = fullyqualified.substring(0, ind);
                String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
                if (classTable.get(class_name) != null) continue;
                classTable.put(class_name, fullyqualified);
                class_list = (ArrayList)packageTable.get(class_package);
                if (class_list == null) {
                    class_list = new ArrayList<String>();
                    packageTable.put(class_package, class_list);
                }
                class_list.add(class_name);
            }
        }
        interp.resetResult();
    }

    public static String getImport(Interp interp, String name) {
        HashMap classTable = interp.importTable[0];
        return (String)classTable.get(name);
    }
}

