/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.Iterator;
import java9.util.Objects;
import java9.util.function.Consumer;
import java9.util.function.DoubleConsumer;
import java9.util.function.IntConsumer;
import java9.util.function.LongConsumer;

public interface PrimitiveIterator<T, T_CONS>
extends Iterator<T> {
    public void forEachRemaining(T_CONS var1);

    public static interface OfDouble
    extends PrimitiveIterator<Double, DoubleConsumer> {
        public double nextDouble();

        @Override
        default public void forEachRemaining(DoubleConsumer action) {
            Objects.requireNonNull(action);
            while (this.hasNext()) {
                action.accept(this.nextDouble());
            }
        }

        @Override
        default public Double next() {
            return this.nextDouble();
        }

        @Override
        default public void forEachRemaining(Consumer<? super Double> action) {
            if (action instanceof DoubleConsumer) {
                this.forEachRemaining((DoubleConsumer)((Object)action));
            } else {
                Objects.requireNonNull(action);
                this.forEachRemaining(action::accept);
            }
        }
    }

    public static interface OfLong
    extends PrimitiveIterator<Long, LongConsumer> {
        public long nextLong();

        @Override
        default public void forEachRemaining(LongConsumer action) {
            Objects.requireNonNull(action);
            while (this.hasNext()) {
                action.accept(this.nextLong());
            }
        }

        @Override
        default public Long next() {
            return this.nextLong();
        }

        @Override
        default public void forEachRemaining(Consumer<? super Long> action) {
            if (action instanceof LongConsumer) {
                this.forEachRemaining((LongConsumer)((Object)action));
            } else {
                Objects.requireNonNull(action);
                this.forEachRemaining(action::accept);
            }
        }
    }

    public static interface OfInt
    extends PrimitiveIterator<Integer, IntConsumer> {
        public int nextInt();

        @Override
        default public void forEachRemaining(IntConsumer action) {
            Objects.requireNonNull(action);
            while (this.hasNext()) {
                action.accept(this.nextInt());
            }
        }

        @Override
        default public Integer next() {
            return this.nextInt();
        }

        @Override
        default public void forEachRemaining(Consumer<? super Integer> action) {
            if (action instanceof IntConsumer) {
                this.forEachRemaining((IntConsumer)((Object)action));
            } else {
                Objects.requireNonNull(action);
                this.forEachRemaining(action::accept);
            }
        }
    }
}

