/*
 * Decompiled with CFR 0.152.
 */
package java9.util;

import java.util.concurrent.PriorityBlockingQueue;
import java9.util.Objects;
import java9.util.Spliterator;
import java9.util.function.Consumer;

final class PBQueueSpliterator<E>
implements Spliterator<E> {
    private final PriorityBlockingQueue<E> queue;
    private Object[] array;
    private int index;
    private int fence;

    private PBQueueSpliterator(PriorityBlockingQueue<E> queue, Object[] array, int index, int fence) {
        this.queue = queue;
        this.array = array;
        this.index = index;
        this.fence = fence;
    }

    static <T> Spliterator<T> spliterator(PriorityBlockingQueue<T> queue) {
        return new PBQueueSpliterator<T>(queue, null, 0, -1);
    }

    private int getFence() {
        if (this.array == null) {
            this.array = this.queue.toArray();
            this.fence = this.array.length;
        }
        return this.fence;
    }

    @Override
    public PBQueueSpliterator<E> trySplit() {
        PBQueueSpliterator<E> pBQueueSpliterator;
        int lo = this.index;
        int hi = this.getFence();
        int mid = lo + hi >>> 1;
        if (lo >= mid) {
            pBQueueSpliterator = null;
        } else {
            this.index = mid;
            PBQueueSpliterator<E> pBQueueSpliterator2 = new PBQueueSpliterator<E>(this.queue, this.array, lo, this.index);
            pBQueueSpliterator = pBQueueSpliterator2;
        }
        return pBQueueSpliterator;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        int hi = this.getFence();
        int lo = this.index;
        Object[] a = this.array;
        this.index = hi;
        for (int i = lo; i < hi; ++i) {
            action.accept(a[i]);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (this.getFence() > this.index && this.index >= 0) {
            action.accept(this.array[this.index++]);
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.getFence() - this.index;
    }

    @Override
    public int characteristics() {
        return 16704;
    }
}

