/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.parser;

import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.impl.EntryImpl;
import org.intabulas.sandler.elements.impl.FeedImpl;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import java.io.InputStream;
import java.io.InputStreamReader;


/**
 * AtomParser
 * 
 * @author Mark Lussier
 * @version $Id: AtomParser.java,v 1.4 2004/01/02 01:43:57 intabulas Exp $
 */
public class AtomParser {


    /**
     * Public contructor
     */
    public AtomParser() {
    }

    /**
     * Parses an InputStream into an Atom Feed object model. Feed is the root element for
     * syndication
     * 
     * @param in the InputStream to parse
     * 
     * @return a Feed instance
     * 
     * @throws XmlPullParserException 
     */
    public Feed parseInput(InputStream in) throws XmlPullParserException {
        Feed result = null;
        XmlPullParser parser = getXPPInstance(in);
        result = new FeedImpl();
        result.loadDocument(parser);
        return result;
    }

    /**
     * Parses an InputStream into an Atom Entry object model. Entry is the root element for
     * the editing API
     * 
     * @param in the InputStream to parse
     * 
     * @return an Entry instance
     * 
     * @throws XmlPullParserException 
     */
    public Entry parseEntryInput(InputStream in) throws XmlPullParserException {

        Entry result = null;
        XmlPullParser parser = getXPPInstance(in);

        result = new EntryImpl();
        result.loadDocument(parser);

        return result;
    }

    /**
     * Creates and returns a XmlPullParser instance
     * 
     * @param in the InputStream to parse
     * 
     * @return an XmlPullParser instance
     * 
     * @throws XmlPullParserException 
     */
    private XmlPullParser getXPPInstance(InputStream in) throws XmlPullParserException {

        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty(XmlPullParserFactory.PROPERTY_NAME), null);

        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(new InputStreamReader(in));

        return parser;

    }


}
