/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.introspection.impl;

import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.introspection.Introspection;


/**
 * IntrospectionImpl
 * 
 * @author Mark Lussier
 * @version $Id: IntrospectionImpl.java,v 1.2 2004/01/02 01:43:57 intabulas Exp $
 */
public class IntrospectionImpl implements Introspection, AtomElement {

    private String _searchUrl;
    private String _createUrl;


    /**
     * Set's the Search URL to return whn an Introspection Query is made
     * 
     * @param url a String representing the Search Entries URL
     */
    public void setSearchUrl(String url) {
        _searchUrl = url;
    }

    /**
     * Returns the Search URL used in  an Introspection Query is made
     * 
     * @return a String representing the Search Entries URL
     */
    public String getSearchUrl() {
        return _searchUrl;
    }

    /**
     * Set's the Create URL to return whn an Introspection Query is made
     * 
     * @param url a String representing the Create Entries URL
     */
    public void setCreateUrl(String url) {
        _createUrl = url;
    }

    /**
     * Returns the Create URL used in  an Introspection Query is made
     * 
     * @return a String representing the Create Entries URL
     */
    public String getCreateUrl() {
        return _createUrl;
    }


    /**
     * Returns a string representation of the object.
     * 
     * @return a String representation of the object.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer(HTMLTAG_START).append(ELEMENT_INTROSPECTION).append(" xmlns=");
        buffer.append(ATOM_NAMESPACE).append(HTMLTAG_CLOSE);

        if (_searchUrl != null && !"".equals(_searchUrl)) {
            buffer.append(HTMLTAG_START).append(ELEMENT_SEARCHENTRY).append(HTMLTAG_CLOSE);
            buffer.append(_searchUrl);
            buffer.append(HTMLTAG_BEGIN).append(ELEMENT_SEARCHENTRY).append(HTMLTAG_CLOSE);
        }


        if (_createUrl != null && !"".equals(_createUrl)) {
            buffer.append(HTMLTAG_START).append(ELEMENT_CREATEENTRY).append(HTMLTAG_CLOSE);
            buffer.append(_createUrl);
            buffer.append(HTMLTAG_BEGIN).append(ELEMENT_CREATEENTRY).append(HTMLTAG_CLOSE);
        }


        buffer.append(HTMLTAG_BEGIN).append(ELEMENT_INTROSPECTION).append(HTMLTAG_CLOSE);
        return buffer.toString();
    }
}
