/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.elements.impl;

import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Person;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import java.io.IOException;

/**
 * PersonImpl
 *
 * @author Mark Lussier
 * @version $Id: PersonImpl.java,v 1.2 2004/02/05 00:05:56 intabulas Exp $
 */
public class PersonImpl implements Person, AtomElement {
    private String _name;
    private String _email;
    private String _url;

    /**
     * Returns the URL of the Author/Contributor
     *
     * @return a String representing the URL
     */
    public String getUrl() {
        return _url;
    }

    /**
     * Set's the URL of the Author/Contributor
     *
     * @param url a String representing the URL
     */
    public void setUrl(String url) {
        _url = url;
    }

    /**
     * Returns the Name of the Author/Contributor
     *
     * @return a String representing the Name
     */
    public String getName() {
        return _name;
    }

    /**
     * Set's the Name of the Author/Contributor
     *
     * @param name a String representing the Name
     */
    public void setName(String name) {
        _name = name;
    }

    /**
     * Returns the Email Address of the Author/Contributor
     *
     * @return a String representing the Email Address
     */
    public String getEmail() {
        return _email;
    }

    /**
     * Set's the Email Address of the Author/Contributor
     *
     * @param email a String representing the Email Address
     */
    public void setEmail(String email) {
        _email = email;
    }

    /**
     * Returns a string representation of the object.
     *
     * @return a String representation of the object.
     */
    public String toString() {

        StringBuffer buffer = new StringBuffer("");

        buffer.append(HTMLTAG_START).append(ELEMENT_NAME).append(HTMLTAG_CLOSE);
        buffer.append(_name);
        buffer.append(HTMLTAG_BEGIN).append(ELEMENT_NAME).append(HTMLTAG_CLOSE);

        if (_email != null) {
            buffer.append(HTMLTAG_START).append(ELEMENT_EMAIL).append(HTMLTAG_CLOSE);
            buffer.append(_email);
            buffer.append(HTMLTAG_BEGIN).append(ELEMENT_EMAIL).append(HTMLTAG_CLOSE);
        }

        if (_url != null) {
            buffer.append(HTMLTAG_START).append(ELEMENT_URL).append(HTMLTAG_CLOSE);
            buffer.append(_url);
            buffer.append(HTMLTAG_BEGIN).append(ELEMENT_URL).append(HTMLTAG_CLOSE);
        }


        return buffer.toString();

    }


    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
        String elementName = parser.getName();
        int eventType = parser.getEventType();
        do {
            if (eventType == XmlPullParser.START_TAG) {
                if (parser.getName().equals(ELEMENT_NAME)) {
                    try {
                        setName(parser.nextText());
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (parser.getName().equals(ELEMENT_EMAIL)) {
                    try {
                        setEmail(parser.nextText());
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                } else if (parser.getName().equals(ELEMENT_URL)) {
                    try {
                        setUrl(parser.nextText());
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                } else if (parser.getName().equals(ELEMENT_HOMEPAGE)) {
                    try {
                        setUrl(parser.nextText());
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                }
//            } else if (eventType == XmlPullParser.END_TAG) {
            }
            try {
                eventType = parser.next();
            } catch (XmlPullParserException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }

        } while (!(eventType == XmlPullParser.END_TAG && elementName.equals(parser.getName())));

    }


}
