/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.elements.impl;

import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Link;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/**
 * LinkImpl
 * 
 * @author Mark Lussier
 * @version $Id: LinkImpl.java,v 1.2 2004/01/02 01:43:57 intabulas Exp $
 */
public class LinkImpl implements Link, AtomElement {


    private String _rel;
    private String _type;
    private String _href;
    private String _title;


    public LinkImpl() {
        super();
    }

    /**
     * @return 
     */
    public String getType() {
        return _type;
    }

    /**
     * @return 
     */
    public String getTitle() {
        return _title;
    }

    /**
     * @return 
     */
    public String getRelationship() {
        return _rel;
    }

    /**
     * @param rel 
     */
    public void setRelationship(String rel) {
        _rel = rel;
    }

    /**
     * @param href 
     */
    public void setHref(String href) {
        _href = href;
    }

    /**
     * @return 
     */
    public String getHref() {
        return _href;
    }

    /**
     * @param type 
     */
    public void setType(String type) {
        _type = type;
    }

    /**
     * @param title 
     */
    public void setTitle(String title) {
        _title = title;
    }

    /**
     * Returns a string representation of the object.
     * 
     * @return a String representation of the object.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer(HTMLTAG_START).append(ELEMENT_LINK);

        if (_rel != null) {
            buffer.append(SPACE).append(ATTRIBUTE_REL).append("=\"").append(_rel).append("\"");
        }

        if (_type != null) {
            buffer.append(SPACE).append(ATTRIBUTE_TYPE).append("=\"").append(_type).append("\"");
        }

        if (_title != null) {
            buffer.append(SPACE).append(ATTRIBUTE_TITLE).append("=\"").append(_title).append("\"");
        }
        if (_href != null) {
            buffer.append(SPACE).append(ATTRIBUTE_HREF).append("=\"").append(_href).append("\"");
        }
        buffer.append(HTMLTAG_END);
        return buffer.toString();
    }

    /**
     * Extract relevant content from the parser stream
     * 
     * @param parser the XML Pull Parser instabce
     * 
     * @throws org.xmlpull.v1.XmlPullParserException
     *          
     */
    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
        processDocumentAttributes(parser);
    }

    /**
     * Process the Attibutes from the Generator Tag
     * 
     * @param parser the XML Pull Parser instabce
     */
    private void processDocumentAttributes(XmlPullParser parser) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; x++) {
            if (parser.getAttributeName(x).equals(ATTRIBUTE_REL)) {
                setRelationship(parser.getAttributeValue(x));
            } else if (parser.getAttributeName(x).equals(ATTRIBUTE_TYPE)) {
                setType(parser.getAttributeValue(x));
            } else if (parser.getAttributeName(x).equals(ATTRIBUTE_HREF)) {
                setHref(parser.getAttributeValue(x));
            } else if (parser.getAttributeName(x).equals(ATTRIBUTE_TITLE)) {
                setTitle(parser.getAttributeValue(x));
            }

        }
    }

}
