/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.elements.impl;

import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Generator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import java.io.IOException;

/**
 * GeneratorImpl
 * 
 * @author Mark Lussier
 * @version $Id: GeneratorImpl.java,v 1.6 2004/01/02 01:43:57 intabulas Exp $
 */
public class GeneratorImpl implements Generator, AtomElement {

    private String _name;
    private String _uri;
    private String _version;


    public GeneratorImpl() {
    }


    public GeneratorImpl(String name, String url, String version) {
        _name = name;
        _uri = url;
        _version = version;
    }


    /**
     * Set'sthe human readable name of the tooklit that generated the feed
     * 
     * @param name a String containg the Generator's Name
     */
    public void setName(String name) {
        _name = name;
    }


    /**
     * Returns the human readable name of the tooklit that generated the feed
     * 
     * @return a String containing the name
     */
    public String getName() {
        return _name;
    }


    /**
     * Set' the URI of the toolkit that generated the feed
     * 
     * @param uri a String containg the Generator's URI
     */
    public void setUri(String uri) {
        _uri = uri;
    }


    /**
     * Returns the URI of the toolkit that generated the feed
     * 
     * @return a String containing the URI
     */
    public String getUri() {
        return _uri;
    }


    /**
     * Returns the version of the toolkit that generated the feed
     * 
     * @return a String containing the version
     */
    public String getVersion() {
        return _version;
    }

    /**
     * Set the version of the toolkit that generated the feed
     * 
     * @param version a String containing the Generator's version
     */
    public void setVersion(String version) {
        this._version = version;
    }


    /**
     * Returns a string representation of the object.
     * 
     * @return a String representation of the object.
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer(HTMLTAG_START).append(ELEMENT_GENERATOR);
        if (_version != null) {
            buffer.append(SPACE).append(ATTRIBUTE_VERSION).append("=\"").append(_name).append("\"");
        }
        if (_uri != null) {
            buffer.append(SPACE).append(ATTRIBUTE_URL).append("=\"").append(_name).append("\"");
        }
        buffer.append(HTMLTAG_CLOSE);
        buffer.append(_name);
        buffer.append(HTMLTAG_BEGIN).append(ELEMENT_GENERATOR).append(HTMLTAG_CLOSE);
        return buffer.toString();
    }

    /**
     * Extract relevant content from the parser stream
     * 
     * @param parser the XML Pull Parser instabce
     * 
     * @throws XmlPullParserException 
     */
    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
        try {
            processDocumentAttributes(parser);
            setName(parser.nextText());
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    /**
     * Process the Attibutes from the Generator Tag
     * 
     * @param parser the XML Pull Parser instabce
     */
    private void processDocumentAttributes(XmlPullParser parser) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; x++) {
            if (parser.getAttributeName(x).equals(ATTRIBUTE_URL)) {
                setUri(parser.getAttributeValue(x));
            } else if (parser.getAttributeName(x).equals(ATTRIBUTE_VERSION)) {
                setVersion(parser.getAttributeValue(x));
            }

        }
    }


}
