/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.elements.impl;

import org.intabulas.sandler.elements.*;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * AbstractEntryElement
 * 
 * @author Mark Lussier
 * @version $Id: AbstractEntryElement.java,v 1.8 2004/02/04 22:09:34 intabulas Exp $
 */
public class AbstractEntryElement implements SandlerEntry, AtomElement, ParseableEntity {

    /* */
    protected Content _title;
    /* */
    protected Content _summary;

    /* */
    protected Date _modified;
    /* */
    protected String _id;
    /* */
    protected Person _author;
    /* */
    protected List _contributorList;

    /* */
    protected List _linksList;

    /**
     *
     */
    public AbstractEntryElement() {
        _contributorList = new ArrayList(1);
        _linksList = new ArrayList(1);
    }

    /**
     * Returns the Entries Summary
     * 
     * @return a Content representing the Summary
     */
    public Content getSummary() {
        return _summary;
    }

    /**
     * Set's the Entries Summary
     * 
     * @param summary a Content representing the Summary
     */
    public void setSummary(Content summary) {
        _summary = summary;
    }

    /**
     * Set's the Entries Summary
     * 
     * @param summary a String representing the Summary
     */
    public void setSummary(String summary) {
        _summary = new ContentImpl(ELEMENT_SUMMARY);
        _summary.setBody(summary);
    }

    /**
     * Returns the Entries Title
     * 
     * @return a String representing the Title
     */
    public Content getTitle() {
        return _title;
    }

    /**
     * Set's the Entries Title
     * 
     * @param title a String representing the Title
     */
    public void setTitle(Content title) {
        _title = title;
        _title.setTagName(ELEMENT_TITLE);  // Thanks to Brian McCallister for the fix
    }


    /**
     * Set's the Entries Title
     * 
     * @param title a String representing the Title
     */
    public void setTitle(String title) {
        _title = new ContentImpl(ELEMENT_TITLE);
        _title.setBody(title);
    }


    /**
     * Returns the date the entry was last modified
     * 
     * @return a Date representing the last time the entry was modified
     */
    public Date getModified() {
        return _modified;
    }

    /**
     * Set's the date the entry was last modified
     * 
     * @param date a Date representing the last time the entry was modified
     */
    public void setModified(Date date) {
        _modified = date;
    }


    /**
     * Returns the Entries ID
     * 
     * @return a String representing the Entry ID
     */
    public String getId() {
        return _id;
    }

    /**
     * Set's the Entries ID
     * 
     * @param id a String representing the Entry ID
     */
    public void setId(String id) {
        _id = id;
    }


    /**
     * Returns the Entries Author
     * 
     * @return a Person representing the Entry Author
     */
    public Person getAuthor() {
        return _author;
    }

    /**
     * Set's the entries Author
     * 
     * @param author a Person representing the Entry Author
     */
    public void setAuthor(Person author) {
        _author = author;
    }


    public boolean removeContributor(Person contributor) {
        boolean result = false;
        if (_contributorList.contains(contributor)) {
            result = _contributorList.remove(contributor);
        }

        return result;

    }

    public boolean addContributor(Person contributor) {
        return _contributorList.add(contributor);
    }

    public int getContributorCount() {
        return _contributorList.size();
    }

    public void removeContributor(int index) {
        if (index >= 0 && index < _contributorList.size()) {
            _contributorList.remove(index);
        }

    }

    /**
     * @param index
     * @return
     */
    public Person getContributor(int index) {
        Person result = null;
        if (index >= 0 && index < _contributorList.size()) {
            result = (Person) _contributorList.get(index);
        }
        return result;

    }

    /**
     * @param index       
     * @param contributor 
     */
    public void addContributor(int index, Person contributor) {
        _contributorList.add(index, contributor);
    }


    /**
     * @param link a Link representing a Link  to the Entry
     */
    public boolean addLink(Link link) {
        return _linksList.add(link);
    }

    /**
     * @param index an int indiciating where in the contributor list to insert this contributor
     * @param link  a Link  representing a Link to the Entry
     */
    public void addLink(int index, Link link) {
        _linksList.add(index, link);
    }

    /**
     * @param index
     * @return a Link representing a Link to the Entry
     */
    public Link getLink(int index) {
        Link result = null;
        if (index >= 0 && index < _linksList.size()) {
            result = (Link) _linksList.get(index);
        }
        return result;
    }

    /**
     * @return an int representing the number of links to the entry
     */
    public int getLinkCount() {
        return _linksList.size();
    }

    /**
     * @param link a Contributor representing a Link to the Entry
     * @return a boolean indicating the sucessful removel of a link
     */
    public boolean removeLink(Link link) {
        boolean result = false;
        if (_linksList.contains(link)) {
            result = _linksList.remove(link);
        }

        return result;
    }

    /**
     * @param index an int indicating which Link in the list to remove
     */
    public void removeLink(int index) {
        if (index >= 0 && index < _linksList.size()) {
            _linksList.remove(index);
        }
    }


    /**
     * Extract relevant content from the parser stream
     *
     * @param parser the XML Pull Parser instabce
     * @throws org.xmlpull.v1.XmlPullParserException
     *
     */
    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
    }


}
