/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.elements;

import java.util.Date;


/**
 * SandlerEntry
 * 
 * @author Mark Lussier
 * @version $Id: SandlerEntry.java,v 1.6 2004/02/04 22:09:35 intabulas Exp $
 */
public interface SandlerEntry {

    /**
     * Returns the Entries Title
     * 
     * @return a Content representing the Title
     */
    Content getTitle();

    /**
     * Set's the Entries Title
     * 
     * @param title a Content representing the Title
     */
    void setTitle(Content title);

    /**
     * Set's the Entries Title
     * 
     * @param title a String representing the Title
     */
    void setTitle(String title);


    /**
     * Returns the Entries Summary
     * 
     * @return a Content  representing the Summary
     */
    Content getSummary();

    /**
     * Set's the Entries Summary
     * 
     * @param summary a Content representing the Summary
     */
    void setSummary(Content summary);


    /**
     * Set's the Entries Summary
     * 
     * @param summary a Content representing the Summary
     */
    void setSummary(String summary);


    /**
     * Returns the date the entry was last modified
     * 
     * @return a Date representing the last time the entry was modified
     */
    Date getModified();

    /**
     * Set's the date the entry was last modified
     * 
     * @param date a Date representing the last time the entry was modified
     */
    void setModified(Date date);

    /**
     * Returns the Entries ID
     * 
     * @return a String representing the Entry ID
     */
    String getId();

    /**
     * Set's the Entries ID
     * 
     * @param id a String representing the Entry ID
     */
    void setId(String id);

    /**
     * Returns the Entries Author
     * 
     * @return a Person representing the Entry Author
     */
    Person getAuthor();

    /**
     * Set's the entries Author
     * 
     * @param author a Person representing the Entry Author
     */
    void setAuthor(Person author);


    /**
     * @return an int representing the number of contributors to the entry
     */
    int getContributorCount();

    /**
     * @param index
     * @return a Person representing a Contributor to the Entry
     */
    Person getContributor(int index);

    /**
     * @param contributor a Person representing a Contributor to the Entry
     */
    boolean addContributor(Person contributor);

    /**
     * @param index       an int indiciating where in the contributor list to insert this contributor
     * @param contributor a Person representing a Contributor to the Entry
     */
    void addContributor(int index, Person contributor);


    /**
     * @param link a Person representing a Link to the Entry
     * @return a boolean indicating the sucessful removel of a link
     */
    boolean removeLink(Link link);


    /**
     * @param index an int indicating which Link in the list to remove
     */
    void removeLink(int index);


    /**
     * @return an int representing the number of links to the entry
     */
    int getLinkCount();

    /**
     * @param index
     * @return a Link representing a Link to the Entry
     */
    Link getLink(int index);

    /**
     * @param link a Link representing a Link  to the Entry
     */
    boolean addLink(Link link);

    /**
     * @param index an int indiciating where in the contributor list to insert this contributor
     * @param link  a Link  representing a Link to the Entry
     */
    void addLink(int index, Link link);


    /**
     * @param contributor a Person representing a Contributor to the Entry
     * @return a boolean indicating the sucessful removel of a contributor
     */
    boolean removeContributor(Person contributor);


    /**
     * @param index an int indicating which contributor in the list to remove
     */
    void removeContributor(int index);


}
