/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.elements;


/**
 * Content
 * 
 * @author Mark Lussier
 * @version $Id: Content.java,v 1.4 2004/01/02 01:43:57 intabulas Exp $
 */
public interface Content extends ParseableEntity {

    /**
     * Returns the MIME Type format of the body content
     * 
     * @return a String representing the MIME Type
     */
    String getMimeType();

    /**
     * Set's the MIME Type format of the body content
     * 
     * @param mimeType a String representing the MIME Type
     */
    void setMimeType(String mimeType);

    /**
     * Returns the method used to encode the body content (ie: xml, escaped, base64)
     * 
     * @return a String representing the encoding
     */
    String getMode();

    /**
     * Set's the method used to encode the body content (ie: xml, escaped, base64)
     * 
     * @param mode a String representing the encoding
     */
    void setMode(String mode);

    /**
     * Retutns the language of the body content (xml:lang)
     * 
     * @return a String representing the content language
     */
    String getLanguage();

    /**
     * Sets the language of the body content (xml:lang)
     * 
     * @param language a String representing the content language
     */
    void setLanguage(String language);

    /**
     * Returns the actual entry content
     * 
     * @return content a String representing the body content
     */
    String getBody();

    /**
     * Set's the entry content
     * 
     * @param content a String representing the body content
     */
    void setBody(String content);

    /**
     * Set's the content tag name
     * 
     * @param tagame 
     */
    void setTagName(String tagame);

}
