/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.elements;


/**
 * AtomElement
 * <p/>
 * See http://www.mnot.net/drafts/draft-nottingham-atom-format-00.html
 * 
 * @author Mark Lussier
 * @version $Id: AtomElement.java,v 1.7 2004/02/04 21:29:59 intabulas Exp $
 */
public interface AtomElement {

    /**
     *
     */
    static final String ATOM_VERSION = "0.2";


    /**
     * Atom XML Constructs
     */

    static final String ELEMENT_FEED = "feed";
    static final String ELEMENT_TITLE = "title";
    static final String ELEMENT_LINK = "link";
    static final String ELEMENT_MODIFIED = "modified";
    static final String ELEMENT_ISSUED = "issued";
    static final String ELEMENT_CREATED = "created";
    static final String ELEMENT_TAGLINE = "tagline";
    static final String ELEMENT_INFO = "info";
    static final String ELEMENT_ID = "id";
    static final String ELEMENT_COPYRIGHT = "copyright";
    static final String ELEMENT_GENERATOR = "generator";
    static final String ELEMENT_AUTHOR = "author";
    static final String ELEMENT_ENTRY = "entry";
    static final String ELEMENT_CONTRIBUTOR = "contributor";
    static final String ELEMENT_NAME = "name";
    static final String ELEMENT_URL = "url";
    static final String ELEMENT_HOMEPAGE = "homepage";
    static final String ELEMENT_SUMMARY = "summary";
    static final String ELEMENT_EMAIL = "email";
    static final String ELEMENT_CONTENT = "content";


    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_LANG = "xml:lang";
    static final String ATTRIBUTE_LANG_NP = "lang";
    static final String ATTRIBUTE_VERSION = "version";
    static final String ATTRIBUTE_TYPE = "type";
    static final String ATTRIBUTE_MODE = "mode";
    static final String ATTRIBUTE_XMLNS = "xmlns";
    static final String ATTRIBUTE_URL = "url";
    static final String ATTRIBUTE_HREF = "href";
    static final String ATTRIBUTE_REL = "rel";
    static final String ATTRIBUTE_TITLE = "title";

    static final String HTMLTAG_START = "<";
    static final String HTMLTAG_CLOSE = ">";
    static final String HTMLTAG_BEGIN = "</";
    static final String HTMLTAG_END = "/>";

    static final String FORMAT_STARTELEMENT = "<{0}{1}>";
    static final String FORMAT_ENDELEMENT = "</{0}>";
    static final String FORMAT_STRINGELEMENT = "<{0}{1}>{2}</{0}>";
    static final String FORMAT_COMMENT = "<!-- {0} -->";

    static final String CDATA_START = "<![CDATA[";
    static final String CDATA_END = "]]>";

    /**
     * Atom Namespace
     */
    static final String ATOM_NAMESPACE = "\"http://purl.org/atom/ns#\"";

    /**
     * Formating Helpers
     */

    static final String XML_STARTDOC = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";

    static final String FORMAT_FEEDATTRIBUTES = ' ' + ATTRIBUTE_VERSION + "=\"{0}\" " +
            ATTRIBUTE_LANG + "=\"{1}\" " + ATTRIBUTE_XMLNS + '=' + ATOM_NAMESPACE;

    static final String FORMAT_NAMEATTRIBUTE = ' ' + ATTRIBUTE_NAME + "=\"{0}\"";

    static final String SPACE = " ";


}
