/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.discovery;

import org.intabulas.sandler.AtomConstants;
import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Feed;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * LinkTagParser
 *
 * @author Mark Lussier
 * @version $Id: LinkTagParser.java,v 1.1 2004/02/05 01:30:40 intabulas Exp $
 */
public class LinkTagParser implements AtomElement {

    String _type = null;
    String _feedUrl = null;

    public LinkTagParser(String type) {
        _type = type;
    }

    public String parseInput(InputStream in) throws XmlPullParserException {
        Feed result = null;
        XmlPullParser parser = getXPPInstance(in);
        loadDocument(parser);

        return _feedUrl;
    }


    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
        int eventType = parser.getEventType();

        do {
            if (eventType == XmlPullParser.START_TAG) {
                if (parser.getName().equalsIgnoreCase(ELEMENT_LINK)) {
                    processDocumentAttributes(parser);
                    if (_feedUrl != null) {
                        break;
                    }
//                    try {
//                        processDocumenteElements(parser);
//                    } catch (IOException e) {
//                        e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
//                    }
                }
            }
            try {
                eventType = parser.next();
            } catch (XmlPullParserException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        } while (eventType != XmlPullParser.END_DOCUMENT);
    }


    private void processDocumenteElements(XmlPullParser parser) throws XmlPullParserException, IOException {

        String elementName = parser.getName();
        int eventType = parser.nextTag();

        do {
            try {
                eventType = parser.next();
            } catch (XmlPullParserException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        } while (!(eventType == XmlPullParser.END_TAG && elementName.equals(parser.getName())));


    }

    private void processDocumentAttributes(XmlPullParser parser) {
        boolean hasAtomType = false;
        String result = null;
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; x++) {
            if (parser.getAttributeName(x).equals(ATTRIBUTE_TYPE)) {
                String type = parser.getAttributeValue(x);
                hasAtomType = AtomConstants.ATOM_LINKTAG_TYPE.equals(type);
            }
            if (parser.getAttributeName(x).equals(ATTRIBUTE_HREF)) {
                result = parser.getAttributeValue(x);
            }

        }
        if (hasAtomType && (result != null)) {
            _feedUrl = result;
        }
    }


    /**
     * Creates and returns a XmlPullParser instance
     *
     * @param in the InputStream to parse
     * @return an XmlPullParser instance
     * @throws XmlPullParserException
     */
    private XmlPullParser getXPPInstance(InputStream in) throws XmlPullParserException {

        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty(XmlPullParserFactory.PROPERTY_NAME), null);

        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(new InputStreamReader(in));

        return parser;

    }

}
