/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.discovery;

import org.intabulas.sandler.AtomConstants;
import org.intabulas.sandler.util.SandlerUtilities;
import org.xmlpull.v1.XmlPullParserException;

import java.io.ByteArrayInputStream;

/**
 * AtomDiscovery, a helper to locate atom <link/> tags in HTML
 *
 * @author Mark Lussier
 * @version $Id: AtomDiscovery.java,v 1.1 2004/02/05 01:30:40 intabulas Exp $
 */
public class AtomDiscovery {

    private String _url = null;

    public AtomDiscovery() {
    }

    public AtomDiscovery(String url) {
        _url = url;
    }

    public String getUrl() {
        return _url;
    }

    public void setUrl(String url) {
        _url = url;
    }


    public String getFeedUrl() {
        String html = SandlerUtilities.downloadUrl(_url);
        return extractLinkTag(html);
    }


    private String extractLinkTag(String html) {
        ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes());
        LinkTagParser parser = new LinkTagParser(AtomConstants.ATOM_LINKTAG_TYPE);
        String result = null;
        try {
            result = parser.parseInput(is);
        } catch (XmlPullParserException e) {
            //@todo clean this up;
            result = null;
        }

        return result;

    }

}
