/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * DigestUtilities
 * 
 * @author Mark Lussier
 * @version $Id: DigestUtilities.java,v 1.2 2004/01/02 01:43:57 intabulas Exp $
 */
public class DigestUtilities {

    /**
     * Performs an SHA Digest onthe given String content
     * 
     * @param data Content to digest
     * 
     * @return The Hash as Hex String
     */
    public static String digestString(String data) {
        return digestString(data, "SHA");
    }

    /**
     * Performs an Digest onthe given String content for the given algorithm
     * 
     * @param data      Content to digest
     * @param algorithm the algorithm to use (MD5, SHA)
     * 
     * @return The Hash as Hex String
     */
    public static String digestString(String data, String algorithm) {
        String result = null;
        if (data != null) {
            try {
                MessageDigest _md = MessageDigest.getInstance(algorithm);
                _md.update(data.getBytes());
                byte[] _digest = _md.digest();

                // Thanks to Sam Ruby for the proper compatible Hex SHA digest
                // http://www.intertwingly.net/blog/1545.html

                String _ds = "";
                for (int x = 0; x < _digest.length; x++) {
                    String hex = Integer.toHexString(_digest[x]);
                    if (hex.length() == 1) {
                        hex = "0" + hex;
                    }
                    hex = hex.substring(hex.length() - 2);
                    _ds = _ds + hex;
                }
                result = _ds;
            } catch (NoSuchAlgorithmException e) {
                result = null;
                result = null;
            }
        }
        return result;
    }


}
