/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler.authentication;

import org.intabulas.sandler.AtomConstants;

/**
 * AtomAuthentication
 * 
 * @author Mark Lussier
 * @version $Id: AtomAuthentication.java,v 1.2 2004/01/02 01:43:57 intabulas Exp $
 */
public class AtomAuthentication implements AtomConstants {

    private String _username;
    private String _relm;
    private String _nonce;
    private String _uri;
    private String _qop;
    private String _nc;
    private String _cnonce;
    private String _response;


    /**
     * @return 
     */
    public String getUsername() {
        return _username;
    }

    /**
     * @param _username 
     */
    public void setUsername(String _username) {
        this._username = _username;
    }

    /**
     * @param authHeader 
     */
    public AtomAuthentication(String authHeader) {
        parseAuthHeader(authHeader);
    }

    /**
     * @param header 
     */
    private void parseAuthHeader(String header) {
        String[] tokens = header.split(",");
        for (int x = 0; x < tokens.length; x++) {
            int index = tokens[x].indexOf('=');
            if (index != -1) {
                String key = tokens[x].substring(0, index).trim();
                String value = tokens[x].substring(index + 1).trim();
                value = value.replaceAll("\"", "");
                if (key.startsWith(ATOM_REALM_KEY)) {
                    key = key.substring(ATOM_REALM_KEY_LENGTH).trim();
                }
                if (key.equalsIgnoreCase(ATOM_AUTHTOKEN_USERNAME)) {
                    _username = value;
                } else if (key.equalsIgnoreCase(ATOM_AUTHTOKEN_REALM)) {
                    _relm = value;
                } else if (key.equalsIgnoreCase(ATOM_AUTHTOKEN_NONCE)) {
                    _nonce = value;
                } else if (key.equalsIgnoreCase(ATOM_AUTHTOKEN_URI)) {
                    _uri = value;
                } else if (key.equalsIgnoreCase(ATOM_AUTHTOKEN_QOP)) {
                    _qop = value;
                } else if (key.equalsIgnoreCase(ATOM_AUTHTOKEN_NC)) {
                    _nc = value;
                } else if (key.equalsIgnoreCase(ATOM_AUTHTOKEN_CNONCE)) {
                    _cnonce = value;
                } else if (key.equalsIgnoreCase(ATOM_AUTHTOKEN_RESPONSE)) {
                    _response = value;

                }
            }
        }

    }

    /**
     * @param password 
     * @param verb     
     * 
     * @return 
     */
    public boolean authenticate(String password, String verb) {
        String a1 = DigestUtilities.digestString(_username + ATOM_DIGEST_SEPERATOR + _relm + ATOM_DIGEST_SEPERATOR + password);
        String a2 = DigestUtilities.digestString(verb + ATOM_DIGEST_SEPERATOR + _uri);
        String check = DigestUtilities.digestString(a1 + ATOM_DIGEST_SEPERATOR + _nonce + ATOM_DIGEST_SEPERATOR + _nc
                + ATOM_DIGEST_SEPERATOR + _cnonce + ATOM_DIGEST_SEPERATOR + _qop + ATOM_DIGEST_SEPERATOR + a2);
        return check.equals(_response);
    }


}
