/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler;

import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.exceptions.FeedMarshallException;
import org.intabulas.sandler.parser.AtomParser;
import org.xmlpull.v1.XmlPullParserException;

import java.io.ByteArrayInputStream;
import java.io.InputStream;


/**
 * Sandler
 * 
 * @author Mark Lussier
 * @version $Id: Sandler.java,v 1.7 2004/02/05 01:30:41 intabulas Exp $
 */

public class Sandler {

    /**
     * Private Constructor
     */
    private Sandler() {
    }

    /**
     * Unmarshall a Atom Feed
     *
     * @param feed
     * @return a Feed instance
     * @throws FeedMarshallException
     */
    public static Feed unmarshallFeed(String feed) throws FeedMarshallException {
        return unmarshallFeed(new ByteArrayInputStream(feed.getBytes()));
    }

    /**
     * Unmarshall a Atom Feed
     *
     * @param stream
     * @return a Feed instance
     * @throws FeedMarshallException
     */
    public static Feed unmarshallFeed(InputStream stream) throws FeedMarshallException {
        AtomParser parser = new AtomParser();
        Feed result = null;
        try {
            result = parser.parseInput(stream);
        } catch (XmlPullParserException e) {
            throw new FeedMarshallException(e);
        }
        return result;
    }

    /**
     * Marshall an Atom Feed
     *
     * @param feed
     * @return an XML representation of a Feed as a String
     */
    public static String marshallFeed(Feed feed) {
        return feed.toString();
    }


    /**
     * Unmarshall an Atom Entry
     *
     * @param entry
     * @return a Entry instance
     * @throws FeedMarshallException
     */
    public static Entry unmarshallEntry(String entry) throws FeedMarshallException {
        return unmarshallEntry(new ByteArrayInputStream(entry.getBytes()));
    }


    /**
     * Unmarshall an Atom Entry
     *
     * @param stream
     * @return a Entry instance
     * @throws FeedMarshallException
     */
    public static Entry unmarshallEntry(InputStream stream) throws FeedMarshallException {
        AtomParser parser = new AtomParser();
        Entry result = null;
        try {
            result = parser.parseEntryInput(stream);
        } catch (XmlPullParserException e) {
            throw new FeedMarshallException(e);
        }
        return result;
    }

    /**
     * Marshall an Atom Entry
     *
     * @param entry
     * @return an XML representation of an Entry as a String
     */
    public static String marshallEntry(Entry entry) {
        return entry.toString();
    }


}
