/**
 * Copyright (c) 2003-2004, Mark Lussier
 * All rights reserved.
 *
 * Portions Copyright (c) 2003 by David A. Czarnecki
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 * Neither the name of the "Mark Lussier" and "Sandler" nor the names of
 * its contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Products derived from this software may not be called "Sandler",
 * nor may "Sandler" appear in their name, without prior written permission of
 * Mark Lussier
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.intabulas.sandler;

/**
 * AtomConstants
 * 
 * @author Mark Lussier
 * @version $Id: AtomConstants.java,v 1.6 2004/02/05 03:08:25 frums Exp $
 */
public interface AtomConstants {

    public static final String ATOM_LINKTAG_TYPE = "application/atom+xml";

    public static final String ATOM_REALM_KEY = "Atom";
    public static final int ATOM_REALM_KEY_LENGTH = ATOM_REALM_KEY.length() + 1;

    public static final char ATOM_DIGEST_SEPERATOR = ':';

    /**
     * Tokens used in Atom Auth
     */
    public static final String ATOM_AUTHTOKEN_USERNAME = "username";
    public static final String ATOM_AUTHTOKEN_REALM = "realm";
    public static final String ATOM_AUTHTOKEN_NONCE = "nonce";
    public static final String ATOM_AUTHTOKEN_URI = "uri";
    public static final String ATOM_AUTHTOKEN_QOP = "qop";
    public static final String ATOM_AUTHTOKEN_NC = "nc";
    public static final String ATOM_AUTHTOKEN_CNONCE = "cnonce";
    public static final String ATOM_AUTHTOKEN_RESPONSE = "response";

    /**
     * Atom Version currently supported
     */
    public static final String VERSION = "0.3";

    /**
     * Standard language tags -- please add them as you need them =)
     */
    public interface Lang {
        public static final String EN_US = "en_US";
    }

    /**
     * Constants enumerating the valid Content modes
     */
    public interface Mode {
        public static final String XML = "xml";
        public static final String ESCAPED = "escaped";
        public static final String BASE64 = "base64";
    }

    /**
     * Constant enumerating the valid Link types
     */
    public interface Rel {
        public static final String ALTERNATE = "alternate";
        public static final String START = "start";
        public static final String NEXT = "next";
        public static final String PREV = "prev";
        public static final String SERVICE_EDIT = "service.edit";
        public static final String SERVICE_POST = "service.post";
        public static final String SERVICE_FEED = "service.feed";
    }

    /**
     * Convenient MIME types most often used in Atom
     */
    public interface Type {
        public static final String TEXT_PLAIN = "text/plain";
        public static final String XML = "text/xml";
        public static final String TEXT_HTML = "text/html";
        public static final String TEXT_XML = "text/xml";
    }

}
