/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j;

import fj.F2;
import fj.data.LazyString;
import fj.data.List;
import net.sourceforge.reb4j.AbstractExpression;
import net.sourceforge.reb4j.Alternation;
import net.sourceforge.reb4j.Alternative;
import net.sourceforge.reb4j.Sequenceable;

public final class Sequence
extends AbstractExpression
implements Alternative,
Sequenceable {
    private static final long serialVersionUID = 1L;
    public final List<Sequenceable> components;

    private Sequence(List<Sequenceable> components) {
        if (components == null) {
            throw new NullPointerException("components");
        }
        this.components = components;
    }

    Sequence(Sequence left, Sequence right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        this.components = left.components.append(right.components);
    }

    Sequence(Sequence left, Sequenceable right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        this.components = left.components.append(List.single((Object)right));
    }

    Sequence(Sequenceable left, Sequence right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        this.components = right.components.cons((Object)left);
    }

    Sequence(Sequenceable left, Sequenceable right) {
        if (left == null) {
            throw new NullPointerException("left");
        }
        if (right == null) {
            throw new NullPointerException("right");
        }
        this.components = List.list((Object[])new Sequenceable[]{left, right});
    }

    public static Sequence sequence(Sequenceable first, Sequenceable second, Sequenceable ... rest) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        if (rest == null) {
            throw new NullPointerException("rest");
        }
        return new Sequence((List<Sequenceable>)List.list((Object[])rest).cons((Object)second).cons((Object)first));
    }

    @Override
    public LazyString expression() {
        return (LazyString)this.components.foldLeft((F2)new F2<LazyString, Sequenceable, LazyString>(){

            public LazyString f(LazyString a, Sequenceable b) {
                return a.append(b.expression());
            }
        }, (Object)LazyString.empty);
    }

    @Override
    public Alternation or(Alternation right) {
        return new Alternation((Alternative)this, right);
    }

    @Override
    public Alternation or(Alternative right) {
        return new Alternation((Alternative)this, right);
    }

    @Override
    @Deprecated
    public Sequence then(Sequenceable right) {
        return this.andThen(right);
    }

    @Override
    @Deprecated
    public Sequence then(Sequence right) {
        return this.andThen(right);
    }

    @Override
    public Sequence andThen(Sequenceable right) {
        return new Sequence(this, right);
    }

    @Override
    public Sequence andThen(Sequence right) {
        return new Sequence(this, right);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.components.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sequence other = (Sequence)obj;
        return this.components.equals(other.components);
    }
}

