/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j;

import fj.data.LazyString;
import net.sourceforge.reb4j.AbstractSequenceableAlternative;
import net.sourceforge.reb4j.Quantifiable;

public final class Quantified
extends AbstractSequenceableAlternative {
    private static final long serialVersionUID = 1L;
    public final Quantifiable base;
    private final LazyString quantifier;

    private Quantified(Quantifiable base, LazyString quantifier) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (quantifier == null) {
            throw new NullPointerException("quantifier");
        }
        this.base = base;
        this.quantifier = quantifier;
    }

    public String quantifier() {
        return this.quantifier.toString();
    }

    public static Quantified anyTimes(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"*"));
    }

    public static Quantified anyTimesReluctantly(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"*?"));
    }

    public static Quantified anyTimesPossessively(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"*+"));
    }

    public static Quantified atLeastOnce(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"+"));
    }

    public static Quantified atLeastOnceReluctantly(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"+?"));
    }

    public static Quantified atLeastOncePossessively(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"++"));
    }

    public static Quantified optional(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"?"));
    }

    public static Quantified optionalReluctantly(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"??"));
    }

    public static Quantified optionalPossessively(Quantifiable base) {
        return new Quantified(base, LazyString.str((String)"?+"));
    }

    public static Quantified repeat(Quantifiable base, int n) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(n)).append("}"));
    }

    public static Quantified repeatReluctantly(Quantifiable base, int n) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(n)).append("}?"));
    }

    public static Quantified repeatPossessively(Quantifiable base, int n) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(n)).append("}+"));
    }

    public static Quantified repeat(Quantifiable base, int min, int max) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(min)).append(",").append(Integer.toString(max)).append("}"));
    }

    public static Quantified repeatReluctantly(Quantifiable base, int min, int max) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(min)).append(",").append(Integer.toString(max)).append("}?"));
    }

    public static Quantified repeatPossessively(Quantifiable base, int min, int max) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(min)).append(",").append(Integer.toString(max)).append("}+"));
    }

    public static Quantified atLeast(Quantifiable base, int n) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(n)).append(",}"));
    }

    public static Quantified atLeastReluctantly(Quantifiable base, int n) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(n)).append(",}?"));
    }

    public static Quantified atLeastPossessively(Quantifiable base, int n) {
        return new Quantified(base, LazyString.str((String)"{").append(Integer.toString(n)).append(",}+"));
    }

    @Override
    public LazyString expression() {
        return this.base.expression().append(this.quantifier);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.base.hashCode();
        result = 31 * result + this.quantifier.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quantified other = (Quantified)obj;
        return this.base.equals(other.base) && this.quantifier.equals(other.quantifier);
    }
}

