/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.SourceCodePositioner;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

class DOMLineNumbers {
    private final Document document;
    private String xmlString;
    private SourceCodePositioner sourceCodePositioner;

    DOMLineNumbers(Document document, String xmlString) {
        this.document = document;
        this.xmlString = xmlString;
        this.sourceCodePositioner = new SourceCodePositioner(xmlString);
    }

    public void determine() {
        this.determineLocation(this.document, 0);
    }

    private int determineLocation(Node n, int index) {
        ProcessingInstruction pi;
        int nextIndex = index;
        int nodeLength = 0;
        int textLength = 0;
        if (n.getNodeType() == 10) {
            nextIndex = this.xmlString.indexOf("<!DOCTYPE", nextIndex);
            nodeLength = "<!DOCTYPE".length();
        } else if (n.getNodeType() == 8) {
            nextIndex = this.xmlString.indexOf("<!--", nextIndex);
        } else if (n.getNodeType() == 1) {
            nextIndex = this.xmlString.indexOf("<" + n.getNodeName(), nextIndex);
            nodeLength = this.xmlString.indexOf(">", nextIndex) - nextIndex + 1;
        } else if (n.getNodeType() == 4) {
            nextIndex = this.xmlString.indexOf("<![CDATA[", nextIndex);
        } else if (n.getNodeType() == 7) {
            pi = (ProcessingInstruction)n;
            nextIndex = this.xmlString.indexOf("<?" + pi.getTarget(), nextIndex);
        } else if (n.getNodeType() == 3) {
            String te = this.unexpandEntities(n, n.getNodeValue(), true);
            int newIndex = this.xmlString.indexOf(te, nextIndex);
            if (newIndex == -1) {
                te = this.unexpandEntities(n, n.getNodeValue(), false);
                newIndex = this.xmlString.indexOf(te, nextIndex);
            }
            if (newIndex > 0) {
                textLength = te.length();
                nextIndex = newIndex;
            }
        } else if (n.getNodeType() == 5) {
            nextIndex = this.xmlString.indexOf("&" + n.getNodeName() + ";", nextIndex);
        }
        this.setBeginLocation(n, nextIndex);
        if (n.hasChildNodes()) {
            nextIndex += nodeLength;
            NodeList childs = n.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                nextIndex = this.determineLocation(childs.item(i), nextIndex);
            }
        }
        if (n.getNodeType() == 1) {
            nextIndex += 2 + n.getNodeName().length() + 1;
        } else if (n.getNodeType() == 10) {
            Node nextSibling = n.getNextSibling();
            nextIndex = nextSibling.getNodeType() == 1 ? this.xmlString.indexOf("<" + nextSibling.getNodeName(), nextIndex) - 1 : (nextSibling.getNodeType() == 8 ? this.xmlString.indexOf("<!--", nextIndex) : this.xmlString.indexOf(">", nextIndex));
        } else if (n.getNodeType() == 8) {
            nextIndex += 7;
            nextIndex += n.getNodeValue().length();
        } else if (n.getNodeType() == 3) {
            nextIndex += textLength;
        } else if (n.getNodeType() == 4) {
            nextIndex += "<![CDATA[".length() + n.getNodeValue().length() + "]]>".length();
        } else if (n.getNodeType() == 7) {
            pi = (ProcessingInstruction)n;
            nextIndex += "<?".length() + pi.getTarget().length() + "?>".length() + pi.getData().length();
        }
        this.setEndLocation(n, nextIndex - 1);
        return nextIndex;
    }

    private String unexpandEntities(Node n, String te, boolean withQuotes) {
        String result = te;
        DocumentType doctype = n.getOwnerDocument().getDoctype();
        result = result.replaceAll(Matcher.quoteReplacement("&"), "&amp;");
        result = result.replaceAll(Matcher.quoteReplacement("<"), "&lt;");
        result = result.replaceAll(Matcher.quoteReplacement(">"), "&gt;");
        if (withQuotes) {
            result = result.replaceAll(Matcher.quoteReplacement("\""), "&quot;");
            result = result.replaceAll(Matcher.quoteReplacement("'"), "&apos;");
        }
        if (doctype != null) {
            NamedNodeMap entities = doctype.getEntities();
            String internalSubset = doctype.getInternalSubset();
            if (internalSubset == null) {
                internalSubset = "";
            }
            for (int i = 0; i < entities.getLength(); ++i) {
                Node item = entities.item(i);
                String entityName = item.getNodeName();
                Node firstChild = item.getFirstChild();
                if (firstChild != null) {
                    result = result.replaceAll(Matcher.quoteReplacement(firstChild.getNodeValue()), "&" + entityName + ";");
                    continue;
                }
                Matcher m = Pattern.compile(Matcher.quoteReplacement("<!ENTITY " + entityName + " ") + "[']([^']*)[']>").matcher(internalSubset);
                if (!m.find()) continue;
                result = result.replaceAll(Matcher.quoteReplacement(m.group(1)), "&" + entityName + ";");
            }
        }
        return result;
    }

    private void setBeginLocation(Node n, int index) {
        if (n != null) {
            int line = this.sourceCodePositioner.lineNumberFromOffset(index);
            int column = this.sourceCodePositioner.columnFromOffset(line, index);
            n.setUserData("pmd:beginLine", line, null);
            n.setUserData("pmd:beginColumn", column, null);
        }
    }

    private void setEndLocation(Node n, int index) {
        if (n != null) {
            int line = this.sourceCodePositioner.lineNumberFromOffset(index);
            int column = this.sourceCodePositioner.columnFromOffset(line, index);
            n.setUserData("pmd:endLine", line, null);
            n.setUserData("pmd:endColumn", column, null);
        }
    }
}

