/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.sourceforge.pmd.PMD;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class BaseCLITest {
    protected static final String TEST_OUPUT_DIRECTORY = "target/cli-tests/";
    protected static final String SOURCE_FOLDER = "src/test/resources/net/sourceforge/pmd/cli";
    protected PrintStream originalOut;
    protected PrintStream originalErr;

    @BeforeClass
    public static void setUp() throws Exception {
        System.setProperty("net.sourceforge.pmd.cli.noExit", "true");
        File testOuputDir = new File(TEST_OUPUT_DIRECTORY);
        if (!testOuputDir.exists()) {
            Assert.assertTrue((String)("failed to create output directory for test:" + testOuputDir.getAbsolutePath()), (boolean)testOuputDir.mkdirs());
        }
    }

    @Before
    public void setup() {
        this.originalOut = System.out;
        this.originalErr = System.err;
    }

    @After
    public void tearDown() {
        IOUtils.closeQuietly((OutputStream)System.out);
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    protected void createTestOutputFile(String filename) {
        try {
            PrintStream out = new PrintStream(Files.newOutputStream(new File(filename).toPath(), new OpenOption[0]));
            System.setOut(out);
            System.setErr(out);
        }
        catch (IOException e) {
            Assert.fail((String)("Can't create file " + filename + " for test."));
        }
    }

    protected String runTest(String[] args, String testname) {
        return this.runTest(args, testname, 0);
    }

    protected String runTest(String[] args, String testname, int expectedExitCode) {
        String filename = TEST_OUPUT_DIRECTORY + testname + ".txt";
        long start = System.currentTimeMillis();
        this.createTestOutputFile(filename);
        System.out.println("Start running test " + testname);
        this.runPMDWith(args);
        this.checkStatusCode(expectedExitCode);
        System.out.println("Test finished successfully after " + (System.currentTimeMillis() - start) + "ms.");
        return filename;
    }

    protected void runPMDWith(String[] args) {
        PMD.main((String[])args);
    }

    protected void checkStatusCode(int expectedExitCode) {
        int statusCode = this.getStatusCode();
        if (statusCode != expectedExitCode) {
            Assert.fail((String)("PMD failed with status code:" + statusCode));
        }
    }

    protected int getStatusCode() {
        return Integer.parseInt(System.getProperty("net.sourceforge.pmd.cli.status"));
    }
}

