/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.testframework;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.testframework.SimpleAggregatorTst;
import net.sourceforge.pmd.testframework.TestDescriptor;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class PMDTestRunner
extends Runner
implements Filterable {
    private final Description desc;
    private final Class<? extends SimpleAggregatorTst> klass;
    private final List<TestDescriptor> allTests = new ArrayList<TestDescriptor>();
    private BlockJUnit4ClassRunner chainedRunner;

    public PMDTestRunner(Class<? extends SimpleAggregatorTst> klass) throws InitializationError {
        this.klass = klass;
        this.desc = Description.createSuiteDescription(klass);
        this.configureRuleTests();
        this.configureUnitTests();
    }

    private void configureRuleTests() throws InitializationError {
        Description root = Description.createSuiteDescription((String)"Rule Tests", (Annotation[])new Annotation[0]);
        try {
            SimpleAggregatorTst test = this.createTestClass();
            test.setUp();
            ArrayList<Rule> rules = new ArrayList<Rule>(test.getRules());
            Collections.sort(rules, new Comparator<Rule>(){

                @Override
                public int compare(Rule o1, Rule o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (Rule r : rules) {
                TestDescriptor[] ruleTests;
                Description ruleDescription = Description.createSuiteDescription((String)r.getName(), (Annotation[])new Annotation[0]);
                root.addChild(ruleDescription);
                for (TestDescriptor t : ruleTests = test.extractTestsFromXml(r)) {
                    Description d = this.createTestDescription(t);
                    ruleDescription.addChild(d);
                    this.allTests.add(t);
                }
            }
            if (!root.getChildren().isEmpty()) {
                this.desc.addChild(root);
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    private SimpleAggregatorTst createTestClass() {
        try {
            return this.klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void configureUnitTests() throws InitializationError {
        TestClass tclass = new TestClass(this.klass);
        if (!tclass.getAnnotatedMethods(Test.class).isEmpty()) {
            Description unitTests = Description.createSuiteDescription((String)"Unit tests", (Annotation[])new Annotation[0]);
            this.chainedRunner = new BlockJUnit4ClassRunner(this.klass);
            for (Description d : this.chainedRunner.getDescription().getChildren()) {
                unitTests.addChild(d);
            }
            this.desc.addChild(unitTests);
        }
    }

    public Description getDescription() {
        return this.desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        SimpleAggregatorTst test = this.createTestClass();
        boolean regressionTestMode = TestDescriptor.inRegressionTestMode();
        for (TestDescriptor t : this.allTests) {
            Description d = this.createTestDescription(t);
            notifier.fireTestStarted(d);
            try {
                if (!regressionTestMode || t.isRegressionTest()) {
                    test.runTest(t);
                    continue;
                }
                notifier.fireTestIgnored(d);
            }
            catch (Throwable e) {
                notifier.fireTestFailure(new Failure(d, e));
            }
            finally {
                notifier.fireTestFinished(d);
            }
        }
        if (this.chainedRunner != null) {
            this.chainedRunner.run(notifier);
        }
    }

    private Description createTestDescription(TestDescriptor t) {
        String d = t.getDescription().replaceAll("\n|\r", " ");
        return Description.createTestDescription(this.klass, (String)(t.getRule().getName() + "::" + t.getNumberInDocument() + " " + d));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<TestDescriptor> it = this.allTests.iterator();
        while (it.hasNext()) {
            TestDescriptor t = it.next();
            Description testDesc = this.createTestDescription(t);
            if (filter.shouldRun(testDesc)) {
                try {
                    filter.apply((Object)t);
                }
                catch (NoTestsRemainException e) {
                    it.remove();
                }
                continue;
            }
            it.remove();
        }
        boolean chainIsEmpty = false;
        try {
            if (this.chainedRunner != null) {
                this.chainedRunner.filter(filter);
            } else {
                chainIsEmpty = true;
            }
        }
        catch (NoTestsRemainException e) {
            chainIsEmpty = true;
        }
        if (this.allTests.isEmpty() && chainIsEmpty) {
            throw new NoTestsRemainException();
        }
    }
}

