/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.File;
import org.apache.tools.ant.BuildFileRule;
import org.apache.tools.ant.Project;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;

public abstract class AbstractAntTestHelper {
    @Rule
    public final BuildFileRule buildRule = new BuildFileRule();
    protected String pathToTestScript = new File("target/clover/test-classes").exists() ? "target/clover/test-classes/net/sourceforge/" + this.mvnWorkaround : "target/test-classes/net/sourceforge/" + this.mvnWorkaround;
    protected String antTestScriptFilename;
    public String mvnWorkaround = "pmd/ant/xml";

    @Before
    public void setUp() {
        this.validatePostConstruct();
        this.buildRule.configureProject(this.pathToTestScript + File.separator + this.antTestScriptFilename);
        Project project = this.buildRule.getProject();
        if (!project.getBaseDir().toString().endsWith(this.mvnWorkaround)) {
            project.setBasedir(project.getBaseDir().toString() + File.separator + this.pathToTestScript);
        }
    }

    private void validatePostConstruct() {
        if (this.pathToTestScript == null || "".equals(this.pathToTestScript) || this.antTestScriptFilename == null || "".equals(this.antTestScriptFilename) || this.mvnWorkaround == null || "".equals(this.mvnWorkaround)) {
            throw new IllegalStateException("Unit tests for Ant script badly initialized");
        }
    }

    public void executeTarget(String target) {
        this.buildRule.executeTarget(target);
    }

    public void assertOutputContaining(String text) {
        Assert.assertTrue((String)("Expected to find \"" + text + "\" in the output, but it's missing"), (boolean)this.buildRule.getOutput().contains(text));
    }
}

