/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTFunctionNode;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.ecmascript.rule.AbstractEcmascriptRule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConsistentReturnRule
extends AbstractEcmascriptRule {
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        return RuleTargetSelector.forTypes(ASTFunctionNode.class, (Class[])new Class[0]);
    }

    @Override
    public Object visit(ASTFunctionNode functionNode, Object data) {
        Boolean hasResult = null;
        for (ASTReturnStatement returnStatement : functionNode.descendants(ASTReturnStatement.class)) {
            if (functionNode != returnStatement.ancestors(ASTFunctionNode.class).first()) continue;
            if (hasResult == null) {
                hasResult = returnStatement.hasResult();
                continue;
            }
            if (hasResult.booleanValue() == returnStatement.hasResult()) continue;
            this.asCtx(data).addViolation((Node)functionNode);
            break;
        }
        return data;
    }
}

