/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.ast.impl.javacc.AbstractJjtreeNode;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserImplTreeConstants;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.ast.LeftRecursiveNode;
import net.sourceforge.pmd.lang.java.ast.TokenUtils;
import net.sourceforge.pmd.lang.java.symbols.table.JSymbolTable;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class AbstractJavaNode
extends AbstractJjtreeNode<AbstractJavaNode, JavaNode>
implements JavaNode {
    protected JSymbolTable symbolTable;
    private ASTCompilationUnit root;

    AbstractJavaNode(int id) {
        super(id);
    }

    public void jjtClose() {
        super.jjtClose();
        if (this instanceof LeftRecursiveNode && this.getNumChildren() > 0) {
            this.fitTokensToChildren(0);
        }
    }

    public final <P, R> R acceptVisitor(AstVisitor<? super P, ? extends R> visitor, P data) {
        if (visitor instanceof JavaVisitor) {
            return this.acceptVisitor((JavaVisitor)visitor, data);
        }
        return (R)visitor.cannotVisit((Node)this, data);
    }

    protected abstract <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> var1, P var2);

    protected void addChild(AbstractJavaNode child, int index) {
        super.addChild((AbstractJjtreeNode)child, index);
    }

    protected void insertChild(AbstractJavaNode child, int index) {
        super.insertChild((AbstractJjtreeNode)child, index);
    }

    protected void removeChildAtIndex(int childIndex) {
        super.removeChildAtIndex(childIndex);
    }

    protected void setImage(String image) {
        super.setImage(image);
    }

    protected void setFirstToken(JavaccToken token) {
        super.setFirstToken(token);
    }

    protected void setLastToken(JavaccToken token) {
        super.setLastToken(token);
    }

    protected void enlargeLeft(JavaccToken child) {
        super.enlargeLeft(child);
    }

    protected void setChild(AbstractJavaNode child, int index) {
        super.setChild((AbstractNode)child, index);
    }

    void setSymbolTable(JSymbolTable table) {
        this.symbolTable = table;
    }

    @Override
    public @NonNull JSymbolTable getSymbolTable() {
        if (this.symbolTable == null) {
            return ((JavaNode)this.getParent()).getSymbolTable();
        }
        return this.symbolTable;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.getRoot().getTypeSystem();
    }

    @Override
    public final @NonNull ASTCompilationUnit getRoot() {
        if (this.root == null) {
            this.setRoot(((JavaNode)this.getParent()).getRoot());
        }
        return this.root;
    }

    void shiftTokens(int leftShift, int rightShift) {
        if (leftShift != 0) {
            this.setFirstToken(this.findTokenSiblingInThisNode(this.getFirstToken(), leftShift));
        }
        if (rightShift != 0) {
            this.setLastToken(this.findTokenSiblingInThisNode(this.getLastToken(), rightShift));
        }
    }

    private JavaccToken findTokenSiblingInThisNode(JavaccToken token, int shift) {
        if (shift == 0) {
            return token;
        }
        if (shift < 0) {
            return TokenUtils.nthPrevious(this.getFirstToken(), token, -shift);
        }
        return TokenUtils.nthFollower(token, shift);
    }

    void copyTextCoordinates(AbstractJavaNode copy) {
        this.setFirstToken(copy.getFirstToken());
        this.setLastToken(copy.getLastToken());
    }

    public final String getXPathNodeName() {
        return JavaParserImplTreeConstants.jjtNodeName[this.id];
    }

    void setRoot(ASTCompilationUnit root) {
        this.root = root;
    }
}

