/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTCompactConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class UnnecessaryReturnRule
extends AbstractJavaRulechainRule {
    public UnnecessaryReturnRule() {
        super(ASTReturnStatement.class, new Class[0]);
    }

    public Object visit(ASTReturnStatement node, Object data) {
        if (node.getNumChildren() > 0) {
            return null;
        }
        NodeStream enclosingStatements = node.ancestorsOrSelf().takeWhile(it -> !this.isCfgLimit((JavaNode)it)).filterIs(ASTStatement.class);
        if (enclosingStatements.all(UnnecessaryReturnRule::isLastStatementOfParent)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return null;
    }

    private boolean isCfgLimit(JavaNode it) {
        return it instanceof ASTExecutableDeclaration || it instanceof ASTCompactConstructorDeclaration || it instanceof ASTInitializer || it instanceof ASTLambdaExpression;
    }

    private static boolean isLastStatementOfParent(ASTStatement it) {
        JavaNode parent = (JavaNode)it.getParent();
        if (JavaAstUtils.isLastChild((Node)it)) {
            if (parent instanceof ASTSwitchArrowBranch) {
                return !UnnecessaryReturnRule.isBranchOfSwitchExpr((ASTSwitchBranch)parent);
            }
            if (parent instanceof ASTSwitchFallthroughBranch) {
                return JavaAstUtils.isLastChild((Node)parent) && !UnnecessaryReturnRule.isBranchOfSwitchExpr((ASTSwitchBranch)parent);
            }
            return !(parent instanceof ASTLoopStatement);
        }
        return parent instanceof ASTIfStatement || parent instanceof ASTTryStatement;
    }

    private static boolean isBranchOfSwitchExpr(ASTSwitchBranch branch) {
        return branch.getParent() instanceof ASTSwitchExpression;
    }
}

