/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class AvoidRethrowingExceptionRule
extends AbstractJavaRulechainRule {
    public AvoidRethrowingExceptionRule() {
        super(ASTTryStatement.class, new Class[0]);
    }

    public Object visit(ASTTryStatement tryStmt, Object data) {
        List catchClauses = tryStmt.getCatchClauses().toList();
        for (int i = 0; i < catchClauses.size(); ++i) {
            List<ASTCatchClause> subsequentCatches;
            ASTCatchClause currentCatch = (ASTCatchClause)catchClauses.get(i);
            if (!JavaAstUtils.isJustRethrowException(currentCatch) || this.hasSubsequentSuperclassCatch(currentCatch, subsequentCatches = catchClauses.subList(i + 1, catchClauses.size()))) continue;
            this.asCtx(data).addViolation((Node)currentCatch);
        }
        return null;
    }

    private boolean hasSubsequentSuperclassCatch(ASTCatchClause currentCatch, List<ASTCatchClause> subsequentCatches) {
        return currentCatch.getParameter().getAllExceptionTypes().any(currentType -> subsequentCatches.stream().anyMatch(subsequentCatch -> subsequentCatch.getParameter().getAllExceptionTypes().any(subsequentType -> currentType.getTypeMirror().isSubtypeOf(subsequentType.getTypeMirror()))));
    }
}

