/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.internal;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameters;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFormalParamSymbol;
import net.sourceforge.pmd.lang.java.symbols.JLocalVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.JSymbolTable;
import net.sourceforge.pmd.lang.java.symbols.table.ScopeInfo;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.NameResolver;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainBuilder;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainNode;
import net.sourceforge.pmd.lang.java.symbols.table.internal.JavaResolvers;
import net.sourceforge.pmd.lang.java.symbols.table.internal.ReferenceCtx;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SymbolTableImpl;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SymTableFactory {
    private final String thisPackage;
    private final JavaAstProcessor processor;
    static final ShadowChainBuilder<JTypeMirror, ScopeInfo> TYPES = new ShadowChainBuilder<JTypeMirror, ScopeInfo>(){

        @Override
        public String getSimpleName(JTypeMirror type) {
            if (type instanceof JClassType) {
                return ((JClassType)type).getSymbol().getSimpleName();
            }
            if (type instanceof JTypeVar) {
                JTypeDeclSymbol sym = type.getSymbol();
                assert (sym != null) : "Must contain named symbols";
                return sym.getSimpleName();
            }
            throw new AssertionError((Object)("Cannot contain type " + type));
        }
    };
    static final ShadowChainBuilder<JVariableSig, ScopeInfo> VARS = new ShadowChainBuilder<JVariableSig, ScopeInfo>(){

        @Override
        public String getSimpleName(JVariableSig sym) {
            return sym.getSymbol().getSimpleName();
        }
    };
    static final ShadowChainBuilder<JMethodSig, ScopeInfo> METHODS = new ShadowChainBuilder<JMethodSig, ScopeInfo>(){

        @Override
        public String getSimpleName(JMethodSig sym) {
            return sym.getName();
        }
    };

    SymTableFactory(String thisPackage, JavaAstProcessor processor) {
        this.thisPackage = thisPackage;
        this.processor = processor;
    }

    public void disambig(NodeStream<? extends JavaNode> nodes, ReferenceCtx context) {
        InternalApiBridge.disambigWithCtx(nodes, context);
    }

    SemanticErrorReporter getLogger() {
        return this.processor.getLogger();
    }

    JClassSymbol loadClassReportFailure(JavaNode location, String fqcn) {
        JClassSymbol loaded = this.loadClassOrFail(fqcn);
        if (loaded == null) {
            this.getLogger().warning((Node)location, "Cannot resolve symbol {0}", new Object[]{fqcn});
        }
        return loaded;
    }

    @Nullable JClassSymbol loadClassOrFail(String fqcn) {
        return this.processor.getSymResolver().resolveClassFromCanonicalName(fqcn);
    }

    private @NonNull JSymbolTable buildTable(JSymbolTable parent, ShadowChainNode<JVariableSig, ScopeInfo> vars, ShadowChainNode<JMethodSig, ScopeInfo> methods, ShadowChainNode<JTypeMirror, ScopeInfo> types) {
        if (vars == parent.variables() && methods == parent.methods() && types == parent.types()) {
            return parent;
        }
        return new SymbolTableImpl(vars, types, methods);
    }

    private ShadowChainNode<JTypeMirror, ScopeInfo> typeNode(JSymbolTable parent) {
        return parent.types().asNode();
    }

    private ShadowChainNode<JVariableSig, ScopeInfo> varNode(JSymbolTable parent) {
        return parent.variables().asNode();
    }

    private ShadowChainNode<JMethodSig, ScopeInfo> methodNode(JSymbolTable parent) {
        return parent.methods().asNode();
    }

    JSymbolTable importsOnDemand(JSymbolTable parent, Collection<ASTImportDeclaration> importsOnDemand) {
        if (importsOnDemand.isEmpty()) {
            return parent;
        }
        ShadowChainBuilder.ResolverBuilder importedTypes = TYPES.new ShadowChainBuilder.ResolverBuilder();
        ShadowChainBuilder.ResolverBuilder importedFields = VARS.new ShadowChainBuilder.ResolverBuilder();
        ArrayList<JClassType> importedMethodContainers = new ArrayList<JClassType>();
        LinkedHashSet<String> lazyImportedPackagesAndTypes = new LinkedHashSet<String>();
        this.fillImportOnDemands(importsOnDemand, importedTypes, importedFields, importedMethodContainers, lazyImportedPackagesAndTypes);
        NameResolver methodResolver = NameResolver.composite(CollectionUtil.map(importedMethodContainers, c -> JavaResolvers.staticImportOnDemandMethodResolver(c, this.thisPackage)));
        ShadowChainNode<JVariableSig, ScopeInfo> vars = VARS.shadow(this.varNode(parent), ScopeInfo.IMPORT_ON_DEMAND, (JVariableSig)((Object)importedFields));
        ShadowChainNode methods = METHODS.shadow(this.methodNode(parent), ScopeInfo.IMPORT_ON_DEMAND, (JMethodSig)((Object)methodResolver));
        ShadowChainNode<JTypeMirror, ScopeInfo> types = lazyImportedPackagesAndTypes.isEmpty() ? TYPES.shadow(this.typeNode(parent), ScopeInfo.IMPORT_ON_DEMAND, (JTypeMirror)((Object)importedTypes)) : TYPES.shadowWithCache(this.typeNode(parent), ScopeInfo.IMPORT_ON_DEMAND, importedTypes.getMutableMap(), JavaResolvers.importedOnDemand(lazyImportedPackagesAndTypes, this.processor.getSymResolver(), this.thisPackage));
        return this.buildTable(parent, vars, methods, types);
    }

    private void fillImportOnDemands(Iterable<ASTImportDeclaration> importsOnDemand, ShadowChainBuilder.ResolverBuilder importedTypes, ShadowChainBuilder.ResolverBuilder importedFields, List<JClassType> importedMethodContainers, Set<String> importedPackagesAndTypes) {
        for (ASTImportDeclaration anImport : importsOnDemand) {
            assert (anImport.isImportOnDemand()) : "Expected import on demand: " + anImport;
            if (anImport.isStatic()) {
                this.fillStaticImportOnDemand(Optional.of(anImport), anImport.getImportedName(), importedTypes, importedFields, importedMethodContainers);
                continue;
            }
            importedPackagesAndTypes.add(anImport.getPackageName());
        }
    }

    private void fillStaticImportOnDemand(Optional<JavaNode> reportLocation, String importedName, ShadowChainBuilder.ResolverBuilder importedTypes, ShadowChainBuilder.ResolverBuilder importedFields, List<JClassType> importedMethodContainers) {
        @Nullable JClassSymbol containerClass = reportLocation.isPresent() ? this.loadClassReportFailure(reportLocation.get(), importedName) : this.loadClassOrFail(importedName);
        if (containerClass != null) {
            JClassType containerType = (JClassType)containerClass.getTypeSystem().typeOf(containerClass, false);
            Pair<ShadowChainBuilder.ResolverBuilder, ShadowChainBuilder.ResolverBuilder> pair = JavaResolvers.importOnDemandMembersResolvers(containerType, this.thisPackage);
            importedTypes.absorb((ShadowChainBuilder.ResolverBuilder)pair.getLeft());
            importedFields.absorb((ShadowChainBuilder.ResolverBuilder)pair.getRight());
            importedMethodContainers.add(containerType);
        }
    }

    JSymbolTable moduleImports(JSymbolTable parent, Collection<ASTImportDeclaration> moduleImports) {
        if (moduleImports.isEmpty()) {
            return parent;
        }
        HashSet<String> lazyImportedModules = new HashSet<String>();
        for (ASTImportDeclaration anImport : moduleImports) {
            assert (anImport.isModuleImport()) : "Expected module import: " + anImport;
            lazyImportedModules.add(anImport.getImportedName());
        }
        ShadowChainBuilder.ResolverBuilder importedTypes = TYPES.new ShadowChainBuilder.ResolverBuilder();
        ShadowChainNode<JTypeMirror, ScopeInfo> types = TYPES.shadowWithCache(this.typeNode(parent), ScopeInfo.MODULE_IMPORT, importedTypes.getMutableMap(), JavaResolvers.moduleImport(lazyImportedModules, this.processor.getSymResolver(), this.thisPackage));
        return SymbolTableImpl.withTypes(parent, types);
    }

    JSymbolTable singleImportsSymbolTable(JSymbolTable parent, Collection<ASTImportDeclaration> singleImports) {
        if (singleImports.isEmpty()) {
            return parent;
        }
        ShadowChainBuilder.ResolverBuilder importedTypes = TYPES.new ShadowChainBuilder.ResolverBuilder();
        ArrayList<NameResolver<? extends JTypeMirror>> importedStaticTypes = new ArrayList<NameResolver<? extends JTypeMirror>>();
        ArrayList<NameResolver<? extends JVariableSig>> importedStaticFields = new ArrayList<NameResolver<? extends JVariableSig>>();
        ArrayList<NameResolver<? extends JMethodSig>> importedStaticMethods = new ArrayList<NameResolver<? extends JMethodSig>>();
        this.fillSingleImports(singleImports, importedTypes);
        this.fillSingleStaticImports(singleImports, importedStaticTypes, importedStaticFields, importedStaticMethods);
        return this.buildTable(parent, VARS.shadow(this.varNode(parent), ScopeInfo.SINGLE_IMPORT, (JVariableSig)((Object)NameResolver.composite(importedStaticFields))), METHODS.shadow(this.methodNode(parent), ScopeInfo.SINGLE_IMPORT, (JMethodSig)((Object)NameResolver.composite(importedStaticMethods))), TYPES.augment((ShadowChainNode<JTypeMirror, ScopeInfo>)TYPES.shadow(this.typeNode(parent), ScopeInfo.SINGLE_IMPORT, (JTypeMirror)((Object)importedTypes.build())), false, ScopeInfo.SINGLE_IMPORT, (JTypeMirror)((Object)NameResolver.composite(importedStaticTypes))));
    }

    private void fillSingleImports(Iterable<ASTImportDeclaration> singleImports, ShadowChainBuilder.ResolverBuilder importedTypes) {
        for (ASTImportDeclaration anImport : singleImports) {
            if (anImport.isImportOnDemand()) {
                throw new IllegalArgumentException(anImport.toString());
            }
            if (anImport.isStatic()) continue;
            JClassSymbol type = this.processor.findSymbolCannotFail(anImport, anImport.getImportedName());
            importedTypes.append(type.getTypeSystem().typeOf(type, false));
        }
    }

    private void fillSingleStaticImports(Iterable<ASTImportDeclaration> singleImports, List<NameResolver<? extends JTypeMirror>> importedTypes, List<NameResolver<? extends JVariableSig>> importedFields, List<NameResolver<? extends JMethodSig>> importedStaticMethods) {
        for (ASTImportDeclaration anImport : singleImports) {
            String className;
            JClassSymbol containerClass;
            int idx;
            if (anImport.isImportOnDemand()) {
                throw new IllegalArgumentException(anImport.toString());
            }
            String simpleName = anImport.getImportedSimpleName();
            String name = anImport.getImportedName();
            if (!anImport.isStatic() || (idx = name.lastIndexOf(46)) < 0 || (containerClass = this.loadClassReportFailure(anImport, className = name.substring(0, idx))) == null) continue;
            JClassType containerType = (JClassType)containerClass.getTypeSystem().declaration(containerClass);
            importedStaticMethods.add(JavaResolvers.staticImportMethodResolver(containerType, this.thisPackage, simpleName));
            importedFields.add(JavaResolvers.staticImportFieldResolver(containerType, this.thisPackage, simpleName));
            importedTypes.add(JavaResolvers.staticImportClassResolver(containerType, this.thisPackage, simpleName));
        }
    }

    JSymbolTable javaLangSymTable(JSymbolTable parent) {
        return this.typesInPackage(parent, "java.lang", ScopeInfo.JAVA_LANG);
    }

    JSymbolTable moduleImportJavaBase(JSymbolTable parent) {
        ShadowChainBuilder.ResolverBuilder importedTypes = TYPES.new ShadowChainBuilder.ResolverBuilder();
        ShadowChainNode<JTypeMirror, ScopeInfo> types = TYPES.shadowWithCache(this.typeNode(parent), ScopeInfo.SIMPLE_COMPILATION_UNIT, importedTypes.getMutableMap(), JavaResolvers.moduleImport(Collections.singleton("java.base"), this.processor.getSymResolver(), this.thisPackage));
        return SymbolTableImpl.withTypes(parent, types);
    }

    JSymbolTable importsOnDemandJavaIo(JSymbolTable parent) {
        ShadowChainBuilder.ResolverBuilder importedTypes = TYPES.new ShadowChainBuilder.ResolverBuilder();
        ShadowChainBuilder.ResolverBuilder importedFields = VARS.new ShadowChainBuilder.ResolverBuilder();
        ArrayList<JClassType> importedMethodContainers = new ArrayList<JClassType>();
        this.fillStaticImportOnDemand(Optional.empty(), "java.io.IO", importedTypes, importedFields, importedMethodContainers);
        NameResolver methodResolver = NameResolver.composite(CollectionUtil.map(importedMethodContainers, c -> JavaResolvers.staticImportOnDemandMethodResolver(c, this.thisPackage)));
        ShadowChainNode<JVariableSig, ScopeInfo> vars = VARS.shadow(this.varNode(parent), ScopeInfo.SIMPLE_COMPILATION_UNIT, (JVariableSig)((Object)importedFields));
        ShadowChainNode methods = METHODS.shadow(this.methodNode(parent), ScopeInfo.SIMPLE_COMPILATION_UNIT, (JMethodSig)((Object)methodResolver));
        ShadowChainNode<JTypeMirror, ScopeInfo> types = TYPES.shadow(this.typeNode(parent), ScopeInfo.SIMPLE_COMPILATION_UNIT, (JTypeMirror)((Object)importedTypes));
        return this.buildTable(parent, vars, methods, types);
    }

    JSymbolTable samePackageSymTable(JSymbolTable parent) {
        return this.typesInPackage(parent, this.thisPackage, ScopeInfo.SAME_PACKAGE);
    }

    private @NonNull JSymbolTable typesInPackage(JSymbolTable parent, String packageName, ScopeInfo scopeTag) {
        assert (AssertionUtil.isValidJavaPackageName((CharSequence)packageName)) : "Not a package name: " + packageName;
        return SymbolTableImpl.withTypes(parent, TYPES.augmentWithCache(this.typeNode(parent), true, scopeTag, JavaResolvers.packageResolver(this.processor.getSymResolver(), packageName)));
    }

    JSymbolTable typeBody(JSymbolTable parent, @NonNull JClassType t) {
        Pair<NameResolver<JTypeMirror>, NameResolver<JVariableSig>> inherited = JavaResolvers.inheritedMembersResolvers(t);
        JClassSymbol sym = t.getSymbol();
        ShadowChainNode<JTypeMirror, ScopeInfo> types = this.typeNode(parent);
        if (!sym.isAnonymousClass()) {
            types = TYPES.shadow(types, ScopeInfo.ENCLOSING_TYPE, t);
        }
        types = TYPES.shadow(types, ScopeInfo.INHERITED, (JTypeMirror)((Object)((NameResolver)inherited.getLeft())));
        types = TYPES.shadow(types, ScopeInfo.ENCLOSING_TYPE_MEMBER, (JTypeMirror)((Object)TYPES.groupByName(t.getDeclaredClasses())));
        types = TYPES.shadow(types, ScopeInfo.TYPE_PARAM, (JTypeMirror)((Object)TYPES.groupByName(sym.getTypeParameters())));
        ShadowChainNode<JVariableSig, ScopeInfo> fields = this.varNode(parent);
        fields = VARS.shadow(fields, ScopeInfo.INHERITED, (JVariableSig)((Object)((NameResolver)inherited.getRight())));
        fields = VARS.shadow(fields, ScopeInfo.ENCLOSING_TYPE_MEMBER, (JVariableSig)((Object)VARS.groupByName(t.getDeclaredFields())));
        ShadowChainNode<JMethodSig, ScopeInfo> methods = this.methodNode(parent);
        BinaryOperator merger = JavaResolvers.methodMerger(Modifier.isStatic(t.getSymbol().getModifiers()));
        methods = METHODS.augmentWithCache(methods, false, ScopeInfo.METHOD_MEMBER, JavaResolvers.subtypeMethodResolver(t), merger);
        return this.buildTable(parent, fields, methods, types);
    }

    JSymbolTable typesInFile(JSymbolTable parent, NodeStream<ASTTypeDeclaration> decls) {
        return SymbolTableImpl.withTypes(parent, TYPES.shadow(this.typeNode(parent), ScopeInfo.SAME_FILE, (JTypeMirror)((Object)TYPES.groupByName(decls, ASTTypeDeclaration::getTypeMirror))));
    }

    JSymbolTable selfType(JSymbolTable parent, JClassType sym) {
        return SymbolTableImpl.withTypes(parent, TYPES.shadow(this.typeNode(parent), ScopeInfo.ENCLOSING_TYPE_MEMBER, (JTypeMirror)((Object)TYPES.groupByName(sym))));
    }

    JSymbolTable typeHeader(JSymbolTable parent, JClassSymbol sym) {
        return SymbolTableImpl.withTypes(parent, TYPES.shadow(this.typeNode(parent), ScopeInfo.TYPE_PARAM, (JTypeMirror)((Object)TYPES.groupByName(sym.getTypeParameters()))));
    }

    JSymbolTable bodyDeclaration(JSymbolTable parent, JClassType enclosing, @Nullable ASTFormalParameters formals, @Nullable ASTTypeParameters tparams) {
        return new SymbolTableImpl(VARS.shadow(this.varNode(parent), ScopeInfo.FORMAL_PARAM, (JVariableSig)((Object)VARS.groupByName(ASTList.orEmptyStream(formals), fp -> {
            ASTVariableId varId = fp.getVarId();
            if (varId.isUnnamed()) {
                return null;
            }
            JVariableSymbol sym = (JVariableSymbol)varId.getSymbol();
            return sym.getTypeSystem().sigOf(enclosing, (JFormalParamSymbol)sym);
        }))), TYPES.shadow(this.typeNode(parent), ScopeInfo.TYPE_PARAM, (JTypeMirror)((Object)TYPES.groupByName(ASTList.orEmptyStream(tparams), ASTTypeParameter::getTypeMirror))), this.methodNode(parent));
    }

    JSymbolTable recordCtor(JSymbolTable parent, JClassType recordType, JConstructorSymbol symbol) {
        return SymbolTableImpl.withVars(parent, VARS.shadow(this.varNode(parent), ScopeInfo.FORMAL_PARAM, (JVariableSig)((Object)VARS.groupByName(symbol.getFormalParameters(), s -> s.getTypeSystem().sigOf(recordType, (JFormalParamSymbol)s)))));
    }

    JSymbolTable localVarSymTable(JSymbolTable parent, JClassType enclosing, Iterable<ASTVariableId> ids) {
        ArrayList<JVariableSig> sigs = new ArrayList<JVariableSig>();
        for (ASTVariableId id : ids) {
            if (id.isUnnamed()) continue;
            sigs.add(id.getTypeSystem().sigOf(enclosing, (JLocalVariableSymbol)id.getSymbol()));
        }
        return SymbolTableImpl.withVars(parent, VARS.augment(this.varNode(parent), false, ScopeInfo.LOCAL, (JVariableSig)((Object)VARS.groupByName(sigs))));
    }

    JSymbolTable localVarSymTable(JSymbolTable parent, JClassType enclosing, ASTVariableId id) {
        assert (!id.isField());
        if (id.isUnnamed()) {
            return parent;
        }
        return SymbolTableImpl.withVars(parent, VARS.augment(this.varNode(parent), false, ScopeInfo.LOCAL, id.getTypeSystem().sigOf(enclosing, (JLocalVariableSymbol)id.getSymbol())));
    }

    JSymbolTable localTypeSymTable(JSymbolTable parent, JClassType sym) {
        return SymbolTableImpl.withTypes(parent, TYPES.augment(this.typeNode(parent), false, ScopeInfo.LOCAL, sym));
    }
}

