/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassNamesUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class SymbolicAnnotationImpl
implements SymbolicValue.SymAnnot {
    private final JClassSymbol typeStub;
    private @NonNull Map<String, SymbolicValue> explicitAttrs = Collections.emptyMap();
    private final boolean runtimeVisible;

    SymbolicAnnotationImpl(AsmSymbolResolver resolver, boolean runtimeVisible, String descriptor) {
        this.runtimeVisible = runtimeVisible;
        this.typeStub = resolver.resolveFromInternalNameCannotFail(ClassNamesUtil.classDescriptorToInternalName(descriptor));
    }

    void addAttribute(String name, SymbolicValue value) {
        if (this.explicitAttrs.isEmpty()) {
            this.explicitAttrs = new HashMap<String, SymbolicValue>();
        }
        this.explicitAttrs.put(name, value);
    }

    @Override
    public @Nullable SymbolicValue getAttribute(String attrName) {
        SymbolicValue value = this.explicitAttrs.get(attrName);
        if (value != null) {
            return value;
        }
        return this.typeStub.getDefaultAnnotationAttributeValue(attrName);
    }

    @Override
    public RetentionPolicy getRetention() {
        return this.runtimeVisible ? RetentionPolicy.RUNTIME : RetentionPolicy.CLASS;
    }

    @Override
    public @NonNull JClassSymbol getAnnotationSymbol() {
        return this.typeStub;
    }

    @Override
    public boolean equals(Object o) {
        return SymbolEquality.ANNOTATION.equals(this, o);
    }

    public int hashCode() {
        return SymbolEquality.ANNOTATION.hash(this);
    }

    public String toString() {
        return SymbolToStrings.ASM.toString(this);
    }
}

