/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.symbols.JModuleSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolVisitor;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AnnotationBuilderVisitor;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AnnotationOwner;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.Loader;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ParseLock;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

class ModuleStub
implements JModuleSymbol,
AsmStub,
AnnotationOwner {
    private final AsmSymbolResolver resolver;
    private final String moduleName;
    private PSet<SymbolicValue.SymAnnot> annotations = HashTreePSet.empty();
    private Set<String> exportedPackages = new HashSet<String>();
    private final ParseLock parseLock;

    ModuleStub(final AsmSymbolResolver resolver, final String moduleName, final @NonNull Loader loader) {
        this.resolver = resolver;
        this.moduleName = moduleName;
        this.parseLock = new ParseLock("ModuleStub:" + moduleName){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected boolean doParse() throws IOException {
                try (InputStream instream = loader.getInputStream();){
                    if (instream != null) {
                        ClassReader classReader = new ClassReader(instream);
                        ClassVisitor classVisitor = new ClassVisitor(589824){

                            public ModuleVisitor visitModule(String name, int access, String version) {
                                assert (name.equals(moduleName)) : "Expected module-info.class for " + moduleName + ", but got " + name;
                                return new ModuleVisitor(589824){

                                    public void visitExport(String packaze, int access, String ... modules) {
                                        ModuleStub.this.exportedPackages.add(packaze.replace('/', '.'));
                                    }
                                };
                            }

                            public AnnotationBuilderVisitor visitAnnotation(String descriptor, boolean visible) {
                                return new AnnotationBuilderVisitor(ModuleStub.this, resolver, visible, descriptor);
                            }
                        };
                        classReader.accept(classVisitor, 7);
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (IOException e) {
                    throw new IOException("While loading class from " + loader, e);
                }
            }
        };
    }

    @Override
    public AsmSymbolResolver getResolver() {
        return this.resolver;
    }

    @Override
    public boolean isUnresolved() {
        return this.parseLock.isFailed();
    }

    @Override
    public <R, P> R acceptVisitor(SymbolVisitor<R, P> visitor, P param) {
        return null;
    }

    @Override
    public Set<String> getExportedPackages() {
        this.parseLock.ensureParsed();
        return this.exportedPackages;
    }

    @Override
    public String getSimpleName() {
        return this.moduleName;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.getResolver().getTypeSystem();
    }

    @Override
    public void addAnnotation(SymbolicValue.SymAnnot annot) {
        this.annotations = this.annotations.plus((Object)annot);
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getDeclaredAnnotations() {
        this.parseLock.ensureParsed();
        return this.annotations;
    }
}

