/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFormalParamSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.GenericSigBase;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.MemberStubBase;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeAnnotationReceiver;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.TypePath;
import org.pcollections.HashTreePSet;
import org.pcollections.IntTreePMap;
import org.pcollections.PMap;
import org.pcollections.PSet;

abstract class ExecutableStub
extends MemberStubBase
implements JExecutableSymbol,
TypeAnnotationReceiver {
    private final String descriptor;
    protected final GenericSigBase.LazyMethodType type;
    private List<JFormalParamSymbol> params;
    private PMap<Integer, PSet<SymbolicValue.SymAnnot>> parameterAnnotations = IntTreePMap.empty();

    protected ExecutableStub(ClassStub owner, String simpleName, int accessFlags, String descriptor, @Nullable String signature, @Nullable String[] exceptions, boolean skipFirstParam) {
        super(owner, simpleName, accessFlags);
        this.descriptor = descriptor;
        this.type = new GenericSigBase.LazyMethodType(this, descriptor, signature, exceptions, skipFirstParam);
    }

    boolean matches(String name, String descriptor) {
        return this.nameEquals(name) && descriptor.equals(this.descriptor);
    }

    @Override
    public List<JTypeVar> getTypeParameters() {
        return this.type.getTypeParams();
    }

    @Override
    public List<JFormalParamSymbol> getFormalParameters() {
        if (this.params == null) {
            List<JTypeMirror> ptypes = this.type.getParameterTypes();
            ArrayList<FormalParamStub> newParams = new ArrayList<FormalParamStub>(ptypes.size());
            for (int i = 0; i < ptypes.size(); ++i) {
                newParams.add(new FormalParamStub(ptypes.get(i), i));
            }
            this.params = Collections.unmodifiableList(newParams);
        }
        return this.params;
    }

    @Override
    public JTypeMirror getReturnType(Substitution subst) {
        return this.type.getReturnType().subst((Function)subst);
    }

    @Override
    public boolean isVarargs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public int getArity() {
        return this.type.getParameterTypes().size();
    }

    PSet<SymbolicValue.SymAnnot> getFormalParameterAnnotations(int parameterIndex) {
        return (PSet)this.parameterAnnotations.getOrDefault((Object)parameterIndex, (Object)HashTreePSet.empty());
    }

    @Override
    public @Nullable JTypeMirror getAnnotatedReceiverType(Substitution subst) {
        if (!this.hasReceiver()) {
            return null;
        }
        JTypeVisitable receiver = this.getTypeSystem().declaration(this.getEnclosingClass()).subst((Function)subst);
        return this.type.applyReceiverAnnotations((JTypeMirror)receiver);
    }

    @Override
    public List<JTypeMirror> getFormalParameterTypes(Substitution subst) {
        return TypeOps.subst(this.type.getParameterTypes(), (Function<? super SubstVar, ? extends JTypeMirror>)subst);
    }

    @Override
    public List<JTypeMirror> getThrownExceptionTypes(Substitution subst) {
        return TypeOps.subst(this.type.getExceptionTypes(), (Function<? super SubstVar, ? extends JTypeMirror>)subst);
    }

    void setDefaultAnnotValue(@Nullable SymbolicValue defaultAnnotValue) {
    }

    @Override
    public void acceptTypeAnnotation(int typeRef, @Nullable TypePath path, SymbolicValue.SymAnnot annot) {
        this.type.acceptTypeAnnotation(typeRef, path, annot);
    }

    void addParameterAnnotation(int paramIndex, SymbolicValue.SymAnnot annot) {
        PSet newAnnots = ((PSet)this.parameterAnnotations.getOrDefault((Object)paramIndex, (Object)HashTreePSet.empty())).plus((Object)annot);
        this.parameterAnnotations = this.parameterAnnotations.plus((Object)paramIndex, (Object)newAnnots);
    }

    static class CtorStub
    extends ExecutableStub
    implements JConstructorSymbol {
        protected CtorStub(ClassStub owner, int accessFlags, String descriptor, @Nullable String signature, @Nullable String[] exceptions, boolean isInnerNonStaticClass) {
            super(owner, "new", accessFlags, descriptor, signature, exceptions, isInnerNonStaticClass);
        }

        public String toString() {
            return SymbolToStrings.ASM.toString(this);
        }

        public int hashCode() {
            return SymbolEquality.CONSTRUCTOR.hash(this);
        }

        @Override
        public boolean equals(Object obj) {
            return SymbolEquality.CONSTRUCTOR.equals(this, obj);
        }
    }

    static class MethodStub
    extends ExecutableStub
    implements JMethodSymbol {
        private @Nullable SymbolicValue defaultAnnotValue;

        protected MethodStub(ClassStub owner, String simpleName, int accessFlags, String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
            super(owner, simpleName, accessFlags, descriptor, signature, exceptions, false);
        }

        @Override
        public boolean isBridge() {
            return (this.getModifiers() & 0x40) != 0;
        }

        public String toString() {
            return SymbolToStrings.ASM.toString(this);
        }

        public int hashCode() {
            return SymbolEquality.METHOD.hash(this);
        }

        @Override
        public boolean equals(Object obj) {
            return SymbolEquality.METHOD.equals(this, obj);
        }

        @Override
        public @Nullable SymbolicValue getDefaultAnnotationValue() {
            return this.defaultAnnotValue;
        }

        @Override
        void setDefaultAnnotValue(@Nullable SymbolicValue defaultAnnotValue) {
            this.defaultAnnotValue = defaultAnnotValue;
        }
    }

    class FormalParamStub
    implements JFormalParamSymbol {
        private final JTypeMirror type;
        private final int index;

        FormalParamStub(JTypeMirror type, int index) {
            this.type = type;
            this.index = index;
        }

        @Override
        public JExecutableSymbol getDeclaringSymbol() {
            return ExecutableStub.this;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public JTypeMirror getTypeMirror(Substitution subst) {
            return this.type.subst((Function)subst);
        }

        @Override
        public String getSimpleName() {
            return "";
        }

        @Override
        public TypeSystem getTypeSystem() {
            return ExecutableStub.this.getTypeSystem();
        }

        @Override
        public PSet<SymbolicValue.SymAnnot> getDeclaredAnnotations() {
            return ExecutableStub.this.getFormalParameterAnnotations(this.index);
        }
    }
}

