/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JRecordComponentSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AnnotationOwner;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStubBuilder;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ExecutableStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.FieldStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.GenericSigBase;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.Loader;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ParseLock;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.RecordComponentStub;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.LexicalScope;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

final class ClassStub
implements JClassSymbol,
AsmStub,
AnnotationOwner {
    static final int UNKNOWN_ARITY = 0;
    private final AsmSymbolResolver resolver;
    private final Names names;
    private int accessFlags;
    private EnclosingInfo enclosingInfo;
    private GenericSigBase.LazyClassSignature signature;
    private LexicalScope scope;
    private List<JFieldSymbol> fields = new ArrayList<JFieldSymbol>();
    private List<JClassSymbol> memberClasses = new ArrayList<JClassSymbol>();
    private List<JMethodSymbol> methods = new ArrayList<JMethodSymbol>();
    private List<JConstructorSymbol> ctors = new ArrayList<JConstructorSymbol>();
    private List<JRecordComponentSymbol> recordComponents = null;
    private List<JFieldSymbol> enumConstants = null;
    private List<JClassSymbol> permittedSubclasses = null;
    private PSet<SymbolicValue.SymAnnot> annotations = HashTreePSet.empty();
    private PSet<String> annotAttributes;
    private final ParseLock parseLock;
    private static final Pattern INTERNAL_NAME_FORBIDDEN_CHARS = Pattern.compile("[;<>\\[.]");

    private static boolean isValidInternalName(String internalName) {
        return !internalName.isEmpty() && !INTERNAL_NAME_FORBIDDEN_CHARS.matcher(internalName).find();
    }

    ClassStub(final AsmSymbolResolver resolver, String internalName, final @NonNull Loader loader, final int observedArity) {
        assert (ClassStub.isValidInternalName(internalName)) : internalName;
        this.resolver = resolver;
        this.names = new Names(internalName);
        this.parseLock = new ParseLock.CheckedParseLock("ClassStub:" + internalName){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected boolean doParse() throws IOException {
                try (InputStream instream = loader.getInputStream();){
                    if (instream != null) {
                        ClassReader classReader = new ClassReader(instream);
                        ClassStubBuilder builder = new ClassStubBuilder(ClassStub.this, resolver);
                        classReader.accept((ClassVisitor)builder, 7);
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (IOException e) {
                    throw new IOException("While loading class from " + loader, e);
                }
            }

            @Override
            protected void finishParse(boolean failed) {
                if (ClassStub.this.enclosingInfo == null) {
                    ClassStub.this.enclosingInfo = EnclosingInfo.NO_ENCLOSING;
                }
                if (ClassStub.this.signature == null) {
                    assert (failed) : "No signature, but the parse hasn't failed? investigate " + ClassStub.access$200((ClassStub)ClassStub.this).internalName;
                    ClassStub.this.signature = GenericSigBase.LazyClassSignature.defaultWhenUnresolved(ClassStub.this, observedArity);
                }
                ClassStub.this.methods = Collections.unmodifiableList(ClassStub.this.methods);
                ClassStub.this.ctors = Collections.unmodifiableList(ClassStub.this.ctors);
                ClassStub.this.fields = Collections.unmodifiableList(ClassStub.this.fields);
                ClassStub.this.memberClasses = Collections.unmodifiableList(ClassStub.this.memberClasses);
                ClassStub.this.enumConstants = CollectionUtil.makeUnmodifiableAndNonNull((List)ClassStub.this.enumConstants);
                ClassStub.this.recordComponents = CollectionUtil.makeUnmodifiableAndNonNull((List)ClassStub.this.recordComponents);
                if ((ClassStub.this.accessFlags & 0x4000) != 0) {
                    ClassStub.this.permittedSubclasses = Collections.emptyList();
                }
                ClassStub.this.permittedSubclasses = CollectionUtil.makeUnmodifiableAndNonNull((List)ClassStub.this.permittedSubclasses);
                if (ClassStub.this.enclosingInfo.getEnclosingClass() == null && ((ClassStub)ClassStub.this).names.simpleName == null) {
                    ClassStub.this.names.finishOuterClass();
                }
            }

            @Override
            protected boolean postCondition() {
                return ClassStub.this.signature != null && ClassStub.this.enclosingInfo != null && ((ClassStub)ClassStub.this).names.simpleName != null;
            }
        };
    }

    @Override
    public AsmSymbolResolver getResolver() {
        return this.resolver;
    }

    void setHeader(@Nullable String signature, @Nullable String superName, String[] interfaces) {
        this.signature = new GenericSigBase.LazyClassSignature(this, signature, superName, interfaces);
    }

    void setSimpleName(String simpleName) {
        this.names.simpleName = simpleName;
    }

    void setModifiers(int accessFlags, boolean fromClassInfo) {
        int visibilityMask = 7;
        int myAccess = this.accessFlags;
        if (fromClassInfo) {
            accessFlags &= 0xFFFFFFDF;
        } else if ((myAccess & 1) != 0 && (accessFlags & 7) != 1) {
            myAccess &= 0xFFFFFFFE;
        }
        this.accessFlags = myAccess | accessFlags;
        if (fromClassInfo) {
            if ((accessFlags & 0x4000) != 0) {
                this.enumConstants = new ArrayList<JFieldSymbol>();
            }
            if ((accessFlags & 0x10000) != 0) {
                this.recordComponents = new ArrayList<JRecordComponentSymbol>();
            }
        }
    }

    void setEnclosingInfo(ClassStub outer, boolean localOrAnon, @Nullable String methodName, @Nullable String methodDescriptor) {
        if (this.enclosingInfo == null) {
            if (outer == null) {
                assert (methodName == null && methodDescriptor == null) : "Enclosing method requires enclosing class";
                this.enclosingInfo = EnclosingInfo.NO_ENCLOSING;
            } else {
                this.enclosingInfo = new EnclosingInfo(outer, localOrAnon, methodName, methodDescriptor);
            }
        }
    }

    void addField(FieldStub fieldStub) {
        this.fields.add(fieldStub);
        if (fieldStub.isEnumConstant() && this.enumConstants != null) {
            this.enumConstants.add(fieldStub);
        }
    }

    void addMemberClass(ClassStub classStub) {
        classStub.setEnclosingInfo(this, false, null, null);
        this.memberClasses.add(classStub);
    }

    void addMethod(ExecutableStub.MethodStub methodStub) {
        this.methods.add(methodStub);
    }

    void addCtor(ExecutableStub.CtorStub methodStub) {
        this.ctors.add(methodStub);
    }

    void addRecordComponent(RecordComponentStub recordComponentStub) {
        if (this.recordComponents == null) {
            this.recordComponents = new ArrayList<JRecordComponentSymbol>();
        }
        this.recordComponents.add(recordComponentStub);
    }

    void addPermittedSubclass(ClassStub permittedSubclass) {
        if (this.permittedSubclasses == null) {
            this.permittedSubclasses = new ArrayList<JClassSymbol>(2);
        }
        this.permittedSubclasses.add(permittedSubclass);
    }

    @Override
    public void addAnnotation(SymbolicValue.SymAnnot annot) {
        this.annotations = this.annotations.plus((Object)annot);
    }

    @Override
    public @Nullable JClassSymbol getSuperclass() {
        this.parseLock.ensureParsed();
        return this.signature.getRawSuper();
    }

    @Override
    public List<JClassSymbol> getSuperInterfaces() {
        this.parseLock.ensureParsed();
        return this.signature.getRawItfs();
    }

    @Override
    public @Nullable JClassType getSuperclassType(Substitution substitution) {
        this.parseLock.ensureParsed();
        return this.signature.getSuperType(substitution);
    }

    @Override
    public List<JClassType> getSuperInterfaceTypes(Substitution substitution) {
        this.parseLock.ensureParsed();
        return this.signature.getSuperItfs(substitution);
    }

    @Override
    public List<JTypeVar> getTypeParameters() {
        this.parseLock.ensureParsed();
        return this.signature.getTypeParams();
    }

    @Override
    public int getTypeParameterCount() {
        this.parseLock.ensureParsed();
        return this.signature.getTypeParameterCount();
    }

    @Override
    public LexicalScope getLexicalScope() {
        if (this.scope == null) {
            this.scope = JClassSymbol.super.getLexicalScope();
        }
        return this.scope;
    }

    @Override
    public List<JFieldSymbol> getDeclaredFields() {
        this.parseLock.ensureParsed();
        return this.fields;
    }

    @Override
    public List<JMethodSymbol> getDeclaredMethods() {
        this.parseLock.ensureParsed();
        return this.methods;
    }

    @Override
    public List<JConstructorSymbol> getConstructors() {
        this.parseLock.ensureParsed();
        return this.ctors;
    }

    @Override
    public List<JClassSymbol> getDeclaredClasses() {
        this.parseLock.ensureParsed();
        return this.memberClasses;
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getDeclaredAnnotations() {
        this.parseLock.ensureParsed();
        return this.annotations;
    }

    @Override
    public PSet<String> getAnnotationAttributeNames() {
        if (this.annotAttributes == null) {
            this.parseLock.ensureParsed();
            this.annotAttributes = this.isAnnotation() ? (PSet)this.getDeclaredMethods().stream().filter(JMethodSymbol::isAnnotationAttribute).map(JElementSymbol::getSimpleName).collect(CollectionUtil.toPersistentSet()) : HashTreePSet.empty();
        }
        return this.annotAttributes;
    }

    @Override
    public @Nullable SymbolicValue getDefaultAnnotationAttributeValue(String attrName) {
        this.parseLock.ensureParsed();
        if (!this.getAnnotationAttributeNames().contains((Object)attrName)) {
            return null;
        }
        return JClassSymbol.super.getDefaultAnnotationAttributeValue(attrName);
    }

    @Override
    public @Nullable JClassSymbol getEnclosingClass() {
        this.parseLock.ensureParsed();
        return this.enclosingInfo.getEnclosingClass();
    }

    @Override
    public @Nullable JExecutableSymbol getEnclosingMethod() {
        this.parseLock.ensureParsed();
        return this.enclosingInfo.getEnclosingMethod();
    }

    @Override
    public @NonNull List<JFieldSymbol> getEnumConstants() {
        this.parseLock.ensureParsed();
        return this.enumConstants;
    }

    @Override
    public @NonNull List<JRecordComponentSymbol> getRecordComponents() {
        this.parseLock.ensureParsed();
        return this.recordComponents;
    }

    @Override
    public List<JClassSymbol> getPermittedSubtypes() {
        this.parseLock.ensureParsed();
        return this.permittedSubclasses;
    }

    @Override
    public JTypeParameterOwnerSymbol getEnclosingTypeParameterOwner() {
        this.parseLock.ensureParsed();
        return this.enclosingInfo.getEnclosing();
    }

    public String toString() {
        return this.getInternalName();
    }

    public int hashCode() {
        return SymbolEquality.CLASS.hash(this);
    }

    @Override
    public boolean equals(Object obj) {
        return SymbolEquality.CLASS.equals(this, obj);
    }

    public String getInternalName() {
        return this.getNames().internalName;
    }

    private Names getNames() {
        return this.names;
    }

    @Override
    public @NonNull String getBinaryName() {
        return this.getNames().binaryName;
    }

    boolean hasCanonicalName() {
        return this.getCanonicalName() != null;
    }

    @Override
    public @Nullable String getCanonicalName() {
        @Nullable String canoName = this.names.canonicalName;
        if (canoName == null) {
            this.names.canonicalName = canoName = this.computeCanonicalName();
        }
        if ("--NO-CANONICAL-NAME".equals(canoName)) {
            return null;
        }
        return canoName;
    }

    private @NonNull String computeCanonicalName() {
        this.parseLock.ensureParsed();
        if (this.names.canonicalName != null) {
            return this.names.canonicalName;
        }
        if (this.enclosingInfo.isLocalOrAnon()) {
            return "--NO-CANONICAL-NAME";
        }
        assert (this.names.simpleName != null && !this.names.simpleName.isEmpty()) : "Anon class should not take this branch";
        JClassSymbol enclosing = this.enclosingInfo.getEnclosingClass();
        if (enclosing == null) {
            return this.names.binaryName;
        }
        String outerName = enclosing.getCanonicalName();
        if (outerName == null) {
            return "--NO-CANONICAL-NAME";
        }
        return outerName + '.' + this.names.simpleName;
    }

    @Override
    public @NonNull String getPackageName() {
        return this.getNames().packageName;
    }

    @Override
    public @NonNull String getSimpleName() {
        String mySimpleName = this.names.simpleName;
        if (mySimpleName == null) {
            this.parseLock.ensureParsed();
            return Objects.requireNonNull(this.names.simpleName, "Null simple name after parsing " + this.getInternalName());
        }
        return mySimpleName;
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.getResolver().getTypeSystem();
    }

    @Override
    public boolean isUnresolved() {
        return this.parseLock.isFailed();
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public @Nullable JTypeDeclSymbol getArrayComponent() {
        return null;
    }

    @Override
    public int getModifiers() {
        this.parseLock.ensureParsed();
        return this.accessFlags;
    }

    @Override
    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    @Override
    public boolean isClass() {
        return (this.getModifiers() & 0x2200) == 0;
    }

    @Override
    public boolean isRecord() {
        JClassSymbol sup = this.getSuperclass();
        return sup != null && "java.lang.Record".equals(sup.getBinaryName());
    }

    @Override
    public boolean isLocalClass() {
        this.parseLock.ensureParsed();
        return this.enclosingInfo.isLocalOrAnon() && !this.isAnonymousClass();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.getSimpleName().isEmpty();
    }

    boolean isFailed() {
        return this.parseLock.isFailed();
    }

    boolean isNotParsed() {
        return this.parseLock.isNotParsed();
    }

    static class EnclosingInfo {
        static final EnclosingInfo NO_ENCLOSING = new EnclosingInfo(null, false, null, null);
        private final @Nullable JClassSymbol stub;
        private final @Nullable String methodName;
        private final @Nullable String methodDescriptor;
        private final boolean isLocalOrAnon;

        EnclosingInfo(@Nullable JClassSymbol stub, boolean isLocalOrAnon, @Nullable String methodName, @Nullable String methodDescriptor) {
            this.stub = stub;
            this.isLocalOrAnon = isLocalOrAnon;
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
        }

        boolean isLocalOrAnon() {
            return this.isLocalOrAnon;
        }

        public @Nullable JClassSymbol getEnclosingClass() {
            return this.stub;
        }

        public  @Nullable ExecutableStub.MethodStub getEnclosingMethod() {
            if (this.stub instanceof ClassStub && this.methodName != null) {
                ClassStub stub1 = (ClassStub)this.stub;
                stub1.parseLock.ensureParsed();
                for (JMethodSymbol m : stub1.methods) {
                    ExecutableStub.MethodStub ms = (ExecutableStub.MethodStub)m;
                    if (!ms.matches(this.methodName, this.methodDescriptor)) continue;
                    return ms;
                }
            }
            return null;
        }

        JTypeParameterOwnerSymbol getEnclosing() {
            if (this.methodName != null) {
                return this.getEnclosingMethod();
            }
            return this.getEnclosingClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EnclosingInfo that = (EnclosingInfo)o;
            return Objects.equals(this.stub, that.stub) && this.isLocalOrAnon == that.isLocalOrAnon && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.methodDescriptor, that.methodDescriptor);
        }

        public int hashCode() {
            return Objects.hash(this.stub, this.isLocalOrAnon, this.methodName, this.methodDescriptor);
        }
    }

    static class Names {
        private static final String NO_CANONAME = "--NO-CANONICAL-NAME";
        final String binaryName;
        final String internalName;
        final String packageName;
        @Nullable String canonicalName;
        @Nullable String simpleName;

        Names(String internalName) {
            assert (ClassStub.isValidInternalName(internalName)) : internalName;
            int packageEnd = internalName.lastIndexOf(47);
            this.internalName = internalName;
            this.binaryName = internalName.replace('/', '.');
            this.packageName = packageEnd == -1 ? "" : this.binaryName.substring(0, packageEnd);
            if (this.binaryName.indexOf(36, packageEnd + 1) >= 0) {
                this.canonicalName = null;
                this.simpleName = null;
            } else {
                this.canonicalName = this.binaryName;
                this.simpleName = this.binaryName.substring(packageEnd + 1);
            }
        }

        public void finishOuterClass() {
            int packageEnd = this.internalName.lastIndexOf(47);
            this.simpleName = this.binaryName.substring(packageEnd + 1);
            this.canonicalName = this.binaryName;
        }
    }
}

