/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavadocComment;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symbols.JAccessibleElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JModuleSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.ScopeInfo;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainIterator;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.java.types.TypesFromReflection;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.IteratorUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnnecessaryImportRule
extends AbstractJavaRule {
    private static final String UNUSED_IMPORT_MESSAGE = "Unused import ''{0}''";
    private static final String UNUSED_STATIC_IMPORT_MESSAGE = "Unused static import ''{0}''";
    private static final String DUPLICATE_IMPORT_MESSAGE = "Duplicate import ''{0}''";
    private static final String IMPORT_FROM_SAME_PACKAGE_MESSAGE = "Unnecessary import from the current package ''{0}''";
    private static final String IMPORT_FROM_JAVA_LANG_MESSAGE = "Unnecessary import from the java.lang package ''{0}''";
    private static final Logger LOG = LoggerFactory.getLogger(UnnecessaryImportRule.class);
    private final Set<ImportWrapper> allSingleNameImports = new HashSet<ImportWrapper>();
    private final Set<ImportWrapper> staticImportsOnDemand = new HashSet<ImportWrapper>();
    private final Set<ImportWrapper> typeImportsOnDemand = new HashSet<ImportWrapper>();
    private final Set<ImportWrapper> moduleImports = new HashSet<ImportWrapper>();
    private final Set<ImportWrapper> unnecessaryJavaLangImports = new HashSet<ImportWrapper>();
    private final Set<ImportWrapper> unnecessaryImportsFromSamePackage = new HashSet<ImportWrapper>();
    private static final String TYPE_PART_GROUP = "((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?";
    private static final Pattern SEE_PATTERN = Pattern.compile("@see\\s+((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?");
    private static final Pattern LINK_PATTERNS = Pattern.compile("\\{@link(?:plain)?\\s+((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?[\\s\\}]");
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\{@value\\s+(\\p{Alpha}\\w*)[\\s#\\}]");
    private static final Pattern THROWS_PATTERN = Pattern.compile("@throws\\s+(\\p{Alpha}\\w*)");
    private static final Pattern EXCEPTION_PATTERN = Pattern.compile("@exception\\s+(\\p{Alpha}\\w*)");
    private static final Pattern LINK_IN_SNIPPET = Pattern.compile("//\\s*@link\\s+(?:.*?)?target=[\"']?((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?[\"']?");
    private static final Pattern MARKDOWN_PATTERN = Pattern.compile("\\[((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?]");
    private static final Pattern[] PATTERNS = new Pattern[]{SEE_PATTERN, LINK_PATTERNS, VALUE_PATTERN, THROWS_PATTERN, EXCEPTION_PATTERN, LINK_IN_SNIPPET, MARKDOWN_PATTERN};

    public Object visit(ASTCompilationUnit node, Object data) {
        this.moduleImports.clear();
        this.allSingleNameImports.clear();
        this.staticImportsOnDemand.clear();
        this.typeImportsOnDemand.clear();
        this.unnecessaryJavaLangImports.clear();
        this.unnecessaryImportsFromSamePackage.clear();
        String packageName = node.getPackageName();
        for (ASTImportDeclaration importDecl : node.children(ASTImportDeclaration.class)) {
            this.visitImport(importDecl, data, packageName);
        }
        for (ImportWrapper wrapper : this.allSingleNameImports) {
            if (!"java.lang".equals(wrapper.node.getPackageName()) || this.isJavaLangImportNecessary(node, wrapper)) continue;
            this.unnecessaryJavaLangImports.add(wrapper);
        }
        super.visit(node, data);
        this.visitComments(node);
        this.doReporting(data);
        return data;
    }

    private void doReporting(Object data) {
        for (ImportWrapper wrapper : this.allSingleNameImports) {
            String message = wrapper.isStatic() ? UNUSED_STATIC_IMPORT_MESSAGE : UNUSED_IMPORT_MESSAGE;
            this.reportWithMessage(wrapper.node, data, message);
        }
        for (ImportWrapper wrapper : this.staticImportsOnDemand) {
            this.reportWithMessage(wrapper.node, data, UNUSED_STATIC_IMPORT_MESSAGE);
        }
        for (ImportWrapper wrapper : this.typeImportsOnDemand) {
            this.reportWithMessage(wrapper.node, data, UNUSED_IMPORT_MESSAGE);
        }
        for (ImportWrapper wrapper : this.moduleImports) {
            this.reportWithMessage(wrapper.node, data, "Unused module import ''{0}''");
        }
        this.unnecessaryJavaLangImports.removeAll(this.allSingleNameImports);
        this.unnecessaryJavaLangImports.removeAll(this.staticImportsOnDemand);
        this.unnecessaryJavaLangImports.removeAll(this.typeImportsOnDemand);
        this.unnecessaryImportsFromSamePackage.removeAll(this.allSingleNameImports);
        this.unnecessaryImportsFromSamePackage.removeAll(this.staticImportsOnDemand);
        this.unnecessaryImportsFromSamePackage.removeAll(this.typeImportsOnDemand);
        for (ImportWrapper wrapper : this.unnecessaryJavaLangImports) {
            this.reportWithMessage(wrapper.node, data, IMPORT_FROM_JAVA_LANG_MESSAGE);
        }
        for (ImportWrapper wrapper : this.unnecessaryImportsFromSamePackage) {
            this.reportWithMessage(wrapper.node, data, IMPORT_FROM_SAME_PACKAGE_MESSAGE);
        }
    }

    private boolean isJavaLangImportNecessary(ASTCompilationUnit node, ImportWrapper wrapper) {
        ShadowChainIterator<JTypeMirror, ScopeInfo> iter = node.getSymbolTable().types().iterateResults(wrapper.node.getImportedSimpleName());
        if (iter.hasNext()) {
            iter.next();
            if (iter.getScopeTag() == ScopeInfo.SINGLE_IMPORT && iter.hasNext()) {
                iter.next();
                return iter.getScopeTag() != ScopeInfo.JAVA_LANG;
            }
        }
        return false;
    }

    private void visitComments(ASTCompilationUnit node) {
        for (JavaComment comment : node.getComments()) {
            if (!(comment instanceof JavadocComment)) continue;
            String filteredCommentText = IteratorUtil.toStream(comment.getFilteredLines(true)).collect(Collectors.joining("\n"));
            for (Pattern p : PATTERNS) {
                Matcher m = p.matcher(filteredCommentText);
                while (m.find()) {
                    String fullname = m.group(1);
                    if (fullname != null) {
                        this.removeReferenceSingleImport(fullname);
                        this.removeReferenceOnDemandImport(fullname);
                    }
                    if (m.groupCount() > 1 && (fullname = m.group(2)) != null) {
                        for (String param : fullname.split("\\s*,\\s*")) {
                            this.removeReferenceSingleImport(param);
                            this.removeReferenceOnDemandImport(param);
                        }
                    }
                    if (!this.allSingleNameImports.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    private void visitImport(ASTImportDeclaration node, Object data, String thisPackageName) {
        Set<ImportWrapper> container;
        if (thisPackageName.equals(node.getPackageName())) {
            this.unnecessaryImportsFromSamePackage.add(new ImportWrapper(node));
        }
        if (!(container = this.getImportContainer(node)).add(new ImportWrapper(node))) {
            this.reportWithMessage(node, data, DUPLICATE_IMPORT_MESSAGE);
        }
    }

    private Set<ImportWrapper> getImportContainer(ASTImportDeclaration node) {
        if (node.isModuleImport()) {
            return this.moduleImports;
        }
        if (node.isImportOnDemand()) {
            if (node.isStatic()) {
                return this.staticImportsOnDemand;
            }
            return this.typeImportsOnDemand;
        }
        return this.allSingleNameImports;
    }

    private void reportWithMessage(ASTImportDeclaration node, Object data, String message) {
        this.asCtx(data).addViolationWithMessage((Node)node, message, new Object[]{PrettyPrintingUtil.prettyImport(node)});
    }

    public Object visit(ASTClassType node, Object data) {
        if (node.getQualifier() == null && !node.isFullyQualified() && node.getTypeMirror().isClassOrInterface()) {
            JClassSymbol symbol = ((JClassType)node.getTypeMirror()).getSymbol();
            ShadowChainIterator<JTypeMirror, ScopeInfo> scopeIter = node.getSymbolTable().types().iterateResults(node.getSimpleName());
            this.checkScopeChain(false, symbol, scopeIter, ts -> true, false);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTAmbiguousName node, Object data) {
        boolean onlyStatic = !(node.getParent() instanceof ASTClassType);
        this.recordFailedTypeResWithName(node, node.getFirstToken().getImage(), onlyStatic);
        return null;
    }

    private void recordFailedTypeResWithName(JavaNode location, String name, boolean onlyStatics) {
        String target = onlyStatics ? "static " : "";
        LOG.debug("UnnecessaryImport: Failed type res for {} will cause all {}imports named {} to be marked as used", new Object[]{location, target, name});
        boolean foundNamedImport = this.allSingleNameImports.removeIf(decl -> (!onlyStatics || ((ImportWrapper)decl).isStatic()) && name.equals(((ImportWrapper)decl).node.getImportedSimpleName()));
        if (!foundNamedImport) {
            LOG.debug("+ Since no such named import can be found, all {}on-demand-imports will be marked as used", (Object)target);
            if (onlyStatics) {
                this.staticImportsOnDemand.clear();
            } else {
                this.typeImportsOnDemand.clear();
            }
        }
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (node.getQualifier() == null) {
            OverloadSelectionResult overload = node.getOverloadSelectionInfo();
            if (overload.isFailed()) {
                this.recordFailedTypeResWithName(node, node.getMethodName(), true);
                return super.visit(node, data);
            }
            ShadowChainIterator<JMethodSig, ScopeInfo> scopeIter = node.getSymbolTable().methods().iterateResults(node.getMethodName());
            JExecutableSymbol symbol = overload.getMethodType().getSymbol();
            this.checkScopeChain(true, symbol, scopeIter, methods -> CollectionUtil.any((Iterable)methods, m -> m.getSymbol().equals(symbol)), true);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTVariableAccess node, Object data) {
        JVariableSymbol sym = node.getReferencedSym();
        if (sym != null && sym.isField() && ((JFieldSymbol)sym).isStatic()) {
            if (node.getParent() instanceof ASTSwitchLabel && node.ancestors(ASTSwitchLike.class).take(1).any(ASTSwitchLike::isEnumSwitch)) {
                return null;
            }
            ShadowChainIterator<JVariableSig, ScopeInfo> scopeIter = node.getSymbolTable().variables().iterateResults(node.getName());
            this.checkScopeChain(false, (JFieldSymbol)sym, scopeIter, ts -> true, true);
        }
        if (sym == null) {
            this.recordFailedTypeResWithName(node, node.getName(), true);
        }
        return null;
    }

    private <T> void checkScopeChain(boolean recursive, JAccessibleElementSymbol symbol, ShadowChainIterator<T, ScopeInfo> scopeIter, Predicate<List<T>> containsTarget, boolean onlyStatic) {
        while (scopeIter.hasNext()) {
            scopeIter.next();
            if (containsTarget.test(scopeIter.getResults())) {
                if (scopeIter.getScopeTag() == ScopeInfo.SINGLE_IMPORT) {
                    this.allSingleNameImports.removeIf(it -> (((ImportWrapper)it).isStatic() || !onlyStatic) && symbol.getSimpleName().equals(((ImportWrapper)it).node.getImportedSimpleName()));
                } else if (scopeIter.getScopeTag() == ScopeInfo.IMPORT_ON_DEMAND) {
                    boolean found = this.typeImportsOnDemand.removeIf(it -> UnnecessaryImportRule.importOnDemandImportsSymbol(symbol, onlyStatic, it));
                    if (!found) {
                        this.staticImportsOnDemand.removeIf(it -> UnnecessaryImportRule.importOnDemandImportsSymbol(symbol, onlyStatic, it));
                    }
                } else if (scopeIter.getScopeTag() == ScopeInfo.MODULE_IMPORT) {
                    this.moduleImports.removeIf(it -> {
                        if (!(symbol instanceof JTypeDeclSymbol)) {
                            return false;
                        }
                        JTypeDeclSymbol typeSymbol = (JTypeDeclSymbol)symbol;
                        String moduleName = ((ImportWrapper)it).node.getImportedName();
                        String simpleName = typeSymbol.getSimpleName();
                        TypeSystem typeSystem = typeSymbol.getTypeSystem();
                        JModuleSymbol moduleSymbol = typeSystem.getModuleSymbol(moduleName);
                        boolean found = false;
                        for (String packageName : moduleSymbol.getExportedPackages()) {
                            JClassSymbol classSymbol = typeSystem.getClassSymbol(packageName + "." + simpleName);
                            if (classSymbol != null) {
                                found = TypeTestUtil.isA(typeSystem.rawType(typeSymbol), typeSystem.rawType(classSymbol));
                            }
                            if (!found) continue;
                            break;
                        }
                        return found;
                    });
                }
                return;
            }
            if (recursive) continue;
            break;
        }
    }

    private static boolean importOnDemandImportsSymbol(JAccessibleElementSymbol symbol, boolean onlyStatic, ImportWrapper it) {
        if (!it.isStatic() && onlyStatic) {
            return false;
        }
        JClassSymbol symbolOwner = symbol.getEnclosingClass();
        if (symbolOwner == null) {
            return it.node.getImportedName().equals(symbol.getPackageName());
        }
        if (it.node.getImportedName().equals(symbolOwner.getCanonicalName())) {
            return !it.isStatic() || symbol.isStatic();
        }
        TypeSystem ts = symbolOwner.getTypeSystem();
        JClassSymbol importedContainer = ts.getClassSymbol(it.node.getImportedName());
        return importedContainer == null || TypeTestUtil.isA(ts.rawType(symbolOwner), ts.rawType(importedContainer));
    }

    private void removeReferenceSingleImport(String referenceName) {
        String expectedImport = StringUtils.substringBefore((String)referenceName, (String)".");
        this.allSingleNameImports.removeIf(it -> expectedImport.equals(((ImportWrapper)it).node.getImportedSimpleName()));
    }

    private void removeReferenceOnDemandImport(String referenceName) {
        if (referenceName.isEmpty()) {
            return;
        }
        this.typeImportsOnDemand.removeIf(it -> {
            ASTImportDeclaration importNode = ((ImportWrapper)it).node;
            return importNode.isImportOnDemand() && TypesFromReflection.loadSymbol(importNode.getTypeSystem(), importNode.getPackageName() + "." + referenceName) != null;
        });
        this.staticImportsOnDemand.removeIf(it -> {
            ASTImportDeclaration importNode = ((ImportWrapper)it).node;
            if (importNode.isImportOnDemand()) {
                JClassSymbol symbol = TypesFromReflection.loadSymbol(importNode.getTypeSystem(), importNode.getImportedName());
                return symbol != null && symbol.getDeclaredClass(referenceName) != null;
            }
            return false;
        });
    }

    private static final class ImportWrapper {
        private final ASTImportDeclaration node;

        private ImportWrapper(ASTImportDeclaration node) {
            this.node = node;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ImportWrapper that = (ImportWrapper)o;
            return this.node.getImportedName().equals(that.node.getImportedName()) && this.node.isImportOnDemand() == that.node.isImportOnDemand() && this.isStatic() == that.isStatic();
        }

        public int hashCode() {
            return this.node.getImportedName().hashCode() * 31 + Boolean.hashCode(this.node.isStatic()) + 37 * Boolean.hashCode(this.node.isImportOnDemand());
        }

        private boolean isStatic() {
            return this.node.isStatic();
        }
    }
}

