/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.QualifiableExpression;
import net.sourceforge.pmd.lang.java.ast.ReturnScopeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UnnecessaryBoxingRule
extends AbstractJavaRulechainRule {
    private static final Set<String> INTERESTING_NAMES = CollectionUtil.setOf((Object)"valueOf", (Object[])new String[]{"booleanValue", "charValue", "byteValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue"});

    public UnnecessaryBoxingRule() {
        super(ASTMethodCall.class, ASTConstructorCall.class);
    }

    public Object visit(ASTConstructorCall node, Object data) {
        if (node.getTypeMirror().isBoxedPrimitive()) {
            ASTExpression arg = ASTList.singleOrNull(node.getArguments());
            if (arg == null) {
                return null;
            }
            JTypeMirror argT = arg.getTypeMirror();
            if (argT.isPrimitive()) {
                this.checkBox((RuleContext)data, node, arg);
            }
        }
        return null;
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (INTERESTING_NAMES.contains(node.getMethodName())) {
            OverloadSelectionResult overload = node.getOverloadSelectionInfo();
            if (overload.isFailed()) {
                return null;
            }
            JMethodSig m = overload.getMethodType();
            boolean isValueOf = "valueOf".equals(node.getMethodName());
            ASTExpression qualifier = node.getQualifier();
            if (isValueOf && this.isWrapperValueOf(m)) {
                this.checkBox((RuleContext)data, node, (ASTExpression)node.getArguments().get(0));
            } else if (isValueOf && this.isBoxValueOfString(m)) {
                this.checkUnboxing((RuleContext)data, node, m.getDeclaringType());
            } else if (!isValueOf && qualifier != null && this.isUnboxingCall(m)) {
                this.checkBox((RuleContext)data, node, qualifier);
            }
        }
        return null;
    }

    private boolean isUnboxingCall(JMethodSig m) {
        return !m.isStatic() && m.getDeclaringType().isBoxedPrimitive() && m.getArity() == 0 && m.getReturnType().isPrimitive();
    }

    private boolean isWrapperValueOf(JMethodSig m) {
        return m.isStatic() && m.getArity() == 1 && m.getDeclaringType().isBoxedPrimitive() && m.getFormalParameters().get(0).isPrimitive();
    }

    private boolean isBoxValueOfString(JMethodSig m) {
        return m.isStatic() && (m.getArity() == 1 || m.getArity() == 2) && m.getDeclaringType().isBoxedPrimitive() && TypeTestUtil.isA(String.class, m.getFormalParameters().get(0));
    }

    private void checkBox(RuleContext rctx, ASTExpression conversionExpr, ASTExpression convertedExpr) {
        JTypeMirror sourceType = convertedExpr.getTypeMirror();
        JTypeMirror conversionOutput = conversionExpr.getTypeMirror();
        ExprContext ctx = conversionExpr.getConversionContext();
        JTypeMirror ctxType = ctx.getTargetType();
        if (sourceType.isPrimitive() && !conversionOutput.isPrimitive() && ctxType == null && this.isObjectConversionNecessary(conversionExpr)) {
            return;
        }
        String reason = null;
        if (sourceType.equals(conversionOutput)) {
            reason = "boxing of boxed value";
        } else if (this.isImplicitlyTypedLambdaReturnExpr(conversionExpr) || ctxType != null && UnnecessaryBoxingRule.conversionIsImplicitlyRealisable(sourceType, ctxType, ctx, conversionOutput)) {
            if (sourceType.unbox().equals(conversionOutput)) {
                reason = "explicit unboxing";
            } else if (sourceType.box().equals(conversionOutput)) {
                reason = "explicit boxing";
            } else if (ctxType != null) {
                reason = "explicit conversion from " + TypePrettyPrint.prettyPrintWithSimpleNames(sourceType) + " to " + TypePrettyPrint.prettyPrintWithSimpleNames(ctxType);
                if (!conversionOutput.equals(ctxType)) {
                    reason = reason + " through " + TypePrettyPrint.prettyPrintWithSimpleNames(conversionOutput);
                }
            }
        }
        if (reason != null) {
            rctx.addViolation((Node)conversionExpr, new Object[]{reason});
        }
    }

    private static boolean conversionIsImplicitlyRealisable(JTypeMirror sourceType, JTypeMirror ctxType, ExprContext ctx, JTypeMirror conversionOutput) {
        JTypeMirror conv = UnnecessaryBoxingRule.implicitConversionResult(sourceType, ctxType, ctx.getKind());
        return conv != null && conv.equals(UnnecessaryBoxingRule.implicitConversionResult(conversionOutput, ctxType, ctx.getKind())) && UnnecessaryBoxingRule.conversionDoesNotChangesValue(sourceType, conversionOutput);
    }

    private boolean isImplicitlyTypedLambdaReturnExpr(ASTExpression e) {
        JavaNode parent = (JavaNode)e.getParent();
        if (UnnecessaryBoxingRule.isImplicitlyTypedLambda(parent)) {
            return true;
        }
        if (parent instanceof ASTReturnStatement) {
            ReturnScopeNode target = JavaAstUtils.getReturnTarget((ASTReturnStatement)parent);
            return UnnecessaryBoxingRule.isImplicitlyTypedLambda(target);
        }
        return false;
    }

    private static boolean isImplicitlyTypedLambda(JavaNode e) {
        return e instanceof ASTLambdaExpression && !((ASTLambdaExpression)e).isExplicitlyTyped();
    }

    private boolean isObjectConversionNecessary(ASTExpression e) {
        JavaNode parent = (JavaNode)e.getParent();
        return e.getIndexInParent() == 0 && parent instanceof QualifiableExpression;
    }

    private void checkUnboxing(RuleContext rctx, ASTMethodCall methodCall, JTypeMirror conversionOutput) {
        ExprContext ctx = methodCall.getConversionContext();
        JTypeMirror ctxType = ctx.getTargetType();
        if (ctxType != null && this.isImplicitlyConvertible(conversionOutput, ctxType) && conversionOutput.unbox().equals(ctxType)) {
            rctx.addViolation((Node)methodCall, new Object[]{"implicit unboxing. Use " + conversionOutput.getSymbol().getSimpleName() + ".parse" + StringUtils.capitalize((String)ctxType.getSymbol().getSimpleName()) + "(...) instead"});
        }
    }

    private boolean isImplicitlyConvertible(JTypeMirror i, JTypeMirror o) {
        if (i.isBoxedPrimitive() && o.isBoxedPrimitive()) {
            return i.equals(o);
        }
        if (i.isPrimitive() && o.isPrimitive()) {
            return i.isSubtypeOf(o);
        }
        return i.unbox().equals(o.unbox());
    }

    private static @Nullable JTypeMirror implicitConversionResult(JTypeMirror i, JTypeMirror ctx, ExprContext.ExprContextKind kind) {
        if (kind == ExprContext.ExprContextKind.CAST) {
            if (i.isPrimitive() != ctx.isPrimitive()) {
                return i.isPrimitive() ? i.box() : i.unbox();
            }
            if (i.isNumeric() && ctx.isNumeric()) {
                return ctx;
            }
            return i;
        }
        if (!ctx.isPrimitive()) {
            return i.box().isSubtypeOf(ctx) ? i.box() : null;
        }
        if (i.isBoxedPrimitive()) {
            return i.unbox().isSubtypeOf(ctx) ? ctx : null;
        }
        if (i.isPrimitive()) {
            return i.isSubtypeOf(ctx) ? ctx : null;
        }
        return null;
    }

    private static boolean conversionDoesNotChangesValue(JTypeMirror i, JTypeMirror o) {
        return i.box().isSubtypeOf(o.box()) || i.unbox().isSubtypeOf(o.unbox());
    }
}

