/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UnnecessaryCastRule
extends AbstractJavaRulechainRule {
    private static final Set<BinaryOp> BINARY_PROMOTED_OPS = EnumSet.of(BinaryOp.LE, new BinaryOp[]{BinaryOp.GE, BinaryOp.GT, BinaryOp.LT, BinaryOp.ADD, BinaryOp.SUB, BinaryOp.MUL, BinaryOp.DIV, BinaryOp.MOD});

    public UnnecessaryCastRule() {
        super(ASTCastExpression.class, new Class[0]);
    }

    public Object visit(ASTCastExpression castExpr, Object data) {
        ASTExpression operand = castExpr.getOperand();
        @Nullable ExprContext context = castExpr.getConversionContext();
        JTypeMirror coercionType = castExpr.getCastType().getTypeMirror();
        JTypeMirror operandType = operand.getTypeMirror();
        if (TypeOps.isUnresolvedOrNull(operandType) || TypeOps.isUnresolvedOrNull(coercionType)) {
            return null;
        }
        if (operand instanceof ASTLambdaExpression || operand instanceof ASTMethodReference) {
            if (context.isMissing() || context.hasKind(ExprContext.ExprContextKind.INVOCATION)) {
                return null;
            }
            if (coercionType.equals(context.getTargetType())) {
                this.reportCast(castExpr, data);
            }
        } else if (this.isCastUnnecessary(castExpr, context, coercionType, operandType)) {
            this.reportCast(castExpr, data);
        }
        return null;
    }

    private boolean isCastUnnecessary(ASTCastExpression castExpr, @NonNull ExprContext context, JTypeMirror coercionType, JTypeMirror operandType) {
        if (UnnecessaryCastRule.isCastDeterminingReturnOfLambda(castExpr) != OptionalBool.NO) {
            return false;
        }
        if (operandType.equals(coercionType)) {
            return true;
        }
        if (context.isMissing()) {
            return !operandType.isBottom() && operandType.isSubtypeOf(coercionType) && !this.isCastToRawType(coercionType, operandType);
        }
        return !UnnecessaryCastRule.isCastDeterminingContext(castExpr, context, coercionType, operandType) && UnnecessaryCastRule.castIsUnnecessaryToMatchContext(context, coercionType, operandType);
    }

    private boolean isCastToRawType(JTypeMirror coercionType, JTypeMirror operandType) {
        return coercionType.isRaw() && !operandType.isRaw();
    }

    private void reportCast(ASTCastExpression castExpr, Object data) {
        this.asCtx(data).addViolation((Node)castExpr, new Object[]{PrettyPrintingUtil.prettyPrintType(castExpr.getCastType())});
    }

    private static boolean castIsUnnecessaryToMatchContext(ExprContext context, JTypeMirror coercionType, JTypeMirror operandType) {
        if (context.hasKind(ExprContext.ExprContextKind.INVOCATION)) {
            return false;
        }
        JTypeMirror contextType = context.getTargetType();
        if (contextType == null) {
            return false;
        }
        if (!TypeConversion.isConvertibleUsingBoxing(operandType, coercionType)) {
            return false;
        }
        if (!context.acceptsType(operandType)) {
            return false;
        }
        boolean isBoxingFollowingCast = contextType.isPrimitive() != coercionType.isPrimitive();
        return !isBoxingFollowingCast || operandType.unbox().isSubtypeOf(contextType.unbox());
    }

    private static boolean isCastDeterminingContext(ASTCastExpression castExpr, ExprContext context, @NonNull JTypeMirror coercionType, JTypeMirror operandType) {
        if (castExpr.getParent() instanceof ASTConditionalExpression && castExpr.getIndexInParent() != 0) {
            return true;
        }
        if (context.hasKind(ExprContext.ExprContextKind.STRING) && JavaAstUtils.isInfixExprWithOperator((JavaNode)castExpr.getParent(), BinaryOp.ADD)) {
            return !TypeTestUtil.isA(String.class, (TypeNode)JavaAstUtils.getOtherOperandIfInInfixExpr(castExpr)) && !TypeTestUtil.isA(String.class, operandType);
        }
        if (context.hasKind(ExprContext.ExprContextKind.NUMERIC) && castExpr.getParent() instanceof ASTInfixExpression) {
            ASTInfixExpression parent = (ASTInfixExpression)castExpr.getParent();
            if (JavaAstUtils.isInfixExprWithOperator((JavaNode)parent, BinaryOp.SHIFT_OPS)) {
                return castExpr == parent.getLeftOperand() && !TypeOps.isStrictSubtype(operandType.unbox(), operandType.getTypeSystem().INT);
            }
            if (JavaAstUtils.isInfixExprWithOperator((JavaNode)parent, BINARY_PROMOTED_OPS)) {
                JTypeMirror promotedTypeWithCast;
                ASTExpression otherOperand = JavaAstUtils.getOtherOperandIfInInfixExpr(castExpr);
                JTypeMirror otherType = otherOperand.getTypeMirror();
                JTypeMirror promotedTypeWithoutCast = TypeConversion.binaryNumericPromotion(operandType, otherType);
                return !promotedTypeWithoutCast.equals(promotedTypeWithCast = TypeConversion.binaryNumericPromotion(coercionType, otherType));
            }
        }
        return false;
    }

    private static OptionalBool isCastDeterminingReturnOfLambda(ASTCastExpression castExpr) {
        ASTLambdaExpression lambda = UnnecessaryCastRule.getLambdaParent(castExpr);
        if (lambda == null) {
            return OptionalBool.NO;
        }
        JExecutableSymbol symbol = lambda.getFunctionalMethod().getSymbol();
        if (symbol.isUnresolved()) {
            return OptionalBool.UNKNOWN;
        }
        boolean contextDependent = TypeOps.isContextDependent(symbol);
        if (!contextDependent) {
            return OptionalBool.NO;
        }
        ExprContext lambdaCtx = lambda.getConversionContext();
        if (lambdaCtx.isMissing()) {
            return OptionalBool.YES;
        }
        if (lambdaCtx.hasKind(ExprContext.ExprContextKind.CAST)) {
            return OptionalBool.NO;
        }
        if (lambdaCtx.hasKind(ExprContext.ExprContextKind.INVOCATION)) {
            InvocationNode parentCall = (InvocationNode)((JavaNode)lambda.getParent()).getParent();
            if (parentCall.getExplicitTypeArguments() != null) {
                return OptionalBool.NO;
            }
            OverloadSelectionResult overload = parentCall.getOverloadSelectionInfo();
            if (overload.isFailed()) {
                return OptionalBool.UNKNOWN;
            }
            JMethodSig parentMethod = overload.getMethodType();
            if (!parentMethod.getSymbol().isGeneric()) {
                return OptionalBool.NO;
            }
            int argIdx = lambda.getIndexInParent();
            JMethodSig genericSig = parentMethod.getSymbol().getGenericSignature();
            JTypeMirror genericLambdaTy = genericSig.ithFormalParam(argIdx, overload.isVarargsCall());
            if (!(genericLambdaTy instanceof JClassType)) {
                return OptionalBool.NO;
            }
            JClassType lambdaTyCapture = (JClassType)genericLambdaTy;
            JMethodSig expectedLambdaMethod = genericLambdaTy.getTypeSystem().sigOf(lambda.getFunctionalMethod().getSymbol(), lambdaTyCapture.getTypeParamSubst());
            return OptionalBool.definitely((boolean)TypeOps.mentionsAny(expectedLambdaMethod.getReturnType(), parentMethod.getTypeParameters()));
        }
        return OptionalBool.UNKNOWN;
    }

    private static @Nullable ASTLambdaExpression getLambdaParent(ASTCastExpression castExpr) {
        JavaNode returnTarget;
        if (castExpr.getParent() instanceof ASTLambdaExpression) {
            return (ASTLambdaExpression)castExpr.getParent();
        }
        if (castExpr.getParent() instanceof ASTReturnStatement && (returnTarget = JavaAstUtils.getReturnTarget((ASTReturnStatement)castExpr.getParent())) instanceof ASTLambdaExpression) {
            return (ASTLambdaExpression)returnTarget;
        }
        return null;
    }
}

