/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CognitiveComplexityRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Integer> REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"reportLevel").desc("Cognitive Complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)15)).build();

    public CognitiveComplexityRule() {
        super(ASTExecutableDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
    }

    private int getReportLevel() {
        return (Integer)this.getProperty(REPORT_LEVEL_DESCRIPTOR);
    }

    public final Object visit(ASTMethodDeclaration node, Object data) {
        return this.visitMethod(node, data);
    }

    public final Object visit(ASTConstructorDeclaration node, Object data) {
        return this.visitMethod(node, data);
    }

    private Object visitMethod(ASTExecutableDeclaration node, Object data) {
        int reportLevel;
        if (!JavaMetrics.COGNITIVE_COMPLEXITY.supports((Node)node)) {
            return data;
        }
        int cognitive = (Integer)MetricsUtil.computeMetric(JavaMetrics.COGNITIVE_COMPLEXITY, (Node)node);
        if (cognitive >= (reportLevel = this.getReportLevel())) {
            this.asCtx(data).addViolation((Node)node, (Object[])new String[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", PrettyPrintingUtil.displaySignature(node), String.valueOf(cognitive), String.valueOf(reportLevel)});
        }
        return data;
    }
}

