/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.ast;

import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value="The API is minimal until more use cases show up, and this is better tested.")
public abstract class ExprContext {
    final ExprContextKind kind;

    private ExprContext(ExprContextKind kind) {
        this.kind = kind;
    }

    public abstract @Nullable JTypeMirror getTargetType();

    public boolean acceptsType(@NonNull JTypeMirror type) {
        AssertionUtil.requireParamNotNull((String)"type", (Object)type);
        JTypeMirror targetType = this.getTargetType();
        return targetType == null || (this.kind == ExprContextKind.CAST ? TypeConversion.isConvertibleInCastContext(type, targetType) : TypeConversion.isConvertibleUsingBoxing(type, targetType));
    }

    public boolean isMissing() {
        return this.kind == ExprContextKind.MISSING;
    }

    public ExprContextKind getKind() {
        return this.kind;
    }

    final boolean canGiveContextToPoly(boolean lambdaOrMethodRef) {
        return this.hasKind(ExprContextKind.ASSIGNMENT) || this.hasKind(ExprContextKind.INVOCATION) || this.hasKind(ExprContextKind.CAST) && lambdaOrMethodRef;
    }

    public @Nullable InvocationNode getInvocNodeIfInvocContext() {
        return this instanceof InvocCtx ? ((InvocCtx)this).node : null;
    }

    public @NonNull ExprContext getToplevelCtx() {
        return this;
    }

    public @Nullable JTypeMirror getPolyTargetType(boolean lambdaOrMethodRef) {
        if (!this.canGiveContextToPoly(lambdaOrMethodRef)) {
            return null;
        }
        return this.getTargetType();
    }

    static ExprContext newOtherContext(@NonNull JTypeMirror targetType, ExprContextKind kind) {
        AssertionUtil.requireParamNotNull((String)"target type", (Object)targetType);
        return new RegularCtx(targetType, kind);
    }

    static ExprContext newInvocContext(InvocationNode invocNode, int argumentIndex) {
        return new InvocCtx(argumentIndex, invocNode);
    }

    public static RegularCtx getMissingInstance() {
        return RegularCtx.NO_CTX;
    }

    public boolean hasKind(ExprContextKind kind) {
        return this.getKind() == kind;
    }

    static final class RegularCtx
    extends ExprContext {
        private static final RegularCtx NO_CTX = new RegularCtx(null, ExprContextKind.MISSING);
        final @Nullable JTypeMirror targetType;

        RegularCtx(@Nullable JTypeMirror targetType, ExprContextKind kind) {
            super(kind);
            assert (kind != ExprContextKind.INVOCATION);
            this.targetType = targetType;
        }

        @Override
        public @Nullable JTypeMirror getTargetType() {
            return this.targetType;
        }

        public String toString() {
            return "RegularCtx{kind=" + (Object)((Object)this.kind) + ", targetType=" + this.targetType + '}';
        }
    }

    public static enum ExprContextKind {
        INVOCATION,
        ASSIGNMENT,
        CAST,
        NUMERIC,
        STRING,
        TERNARY,
        MISSING,
        BOOLEAN;

    }

    private static final class InvocCtx
    extends ExprContext {
        final int arg;
        final InvocationNode node;

        InvocCtx(int arg, InvocationNode node) {
            super(ExprContextKind.INVOCATION);
            this.arg = arg;
            this.node = node;
        }

        @Override
        public @Nullable JTypeMirror getTargetType() {
            OverloadSelectionResult overload = this.node.getOverloadSelectionInfo();
            if (overload.isFailed()) {
                return null;
            }
            return overload.ithFormalParam(this.arg);
        }

        @Override
        public boolean isMissing() {
            return false;
        }

        public String toString() {
            return "InvocCtx{arg=" + this.arg + ", node=" + this.node + '}';
        }
    }
}

