/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.internal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTAnonymousClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompactConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLabeledStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalClassStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTResourceList;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.JSymbolTable;
import net.sourceforge.pmd.lang.java.symbols.table.internal.AbruptCompletionAnalysis;
import net.sourceforge.pmd.lang.java.symbols.table.internal.PatternBindingsUtil;
import net.sourceforge.pmd.lang.java.symbols.table.internal.ReferenceCtx;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SymTableFactory;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SymbolTableImpl;
import net.sourceforge.pmd.lang.java.types.JClassType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pcollections.PSet;

public final class SymbolTableResolver {
    private SymbolTableResolver() {
    }

    public static void traverse(JavaAstProcessor processor, ASTCompilationUnit root) {
        HashSet<DeferredNode> newDeferred;
        SymTableFactory helper = new SymTableFactory(root.getPackageName(), processor);
        ReferenceCtx ctx = ReferenceCtx.root(processor, root);
        Set<DeferredNode> todo = Collections.singleton(new DeferredNode(root, ctx, SymbolTableImpl.EMPTY));
        do {
            newDeferred = new HashSet<DeferredNode>();
            for (DeferredNode deferred : todo) {
                MyVisitor visitor = new MyVisitor(helper, todo, newDeferred);
                visitor.traverse(deferred);
            }
        } while (!(todo = newDeferred).isEmpty());
    }

    private static class MyVisitor
    extends JavaVisitorBase<ReferenceCtx, Void> {
        private final SymTableFactory f;
        private final Deque<JSymbolTable> stack = new ArrayDeque<JSymbolTable>();
        private final Deque<ASTAnyTypeDeclaration> enclosingType = new ArrayDeque<ASTAnyTypeDeclaration>();
        private final Set<DeferredNode> deferredInPrevRound;
        private final Set<DeferredNode> newDeferred;
        private final StatementVisitor stmtVisitor = new StatementVisitor();

        MyVisitor(SymTableFactory helper, Set<DeferredNode> deferredInPrevRound, Set<DeferredNode> newDeferred) {
            this.f = helper;
            this.deferredInPrevRound = deferredInPrevRound;
            this.newDeferred = newDeferred;
        }

        void traverse(DeferredNode task) {
            assert (this.stack.isEmpty()) : "Stack should be empty when starting the traversal";
            this.stack.push(task.localStackTop);
            task.node.acceptVisitor(this, task.enclosingCtx);
            JSymbolTable last = this.stack.pop();
            assert (last == task.localStackTop) : "Unbalanced stack push/pop! Started with " + task.localStackTop + ", finished on " + last;
        }

        @Override
        public Void visit(ASTClassOrInterfaceType node, @NonNull ReferenceCtx data) {
            this.f.disambig((NodeStream<? extends JavaNode>)NodeStream.of((Node)node), data);
            return null;
        }

        @Override
        public Void visit(ASTAmbiguousName node, @NonNull ReferenceCtx data) {
            this.f.disambig((NodeStream<? extends JavaNode>)NodeStream.of((Node)node), data);
            return null;
        }

        @Override
        public Void visit(ASTModifierList node, @NonNull ReferenceCtx ctx) {
            return null;
        }

        @Override
        public Void visit(ASTCompilationUnit node, @NonNull ReferenceCtx ctx) {
            Map isImportOnDemand = (Map)node.children(ASTImportDeclaration.class).collect(Collectors.partitioningBy(ASTImportDeclaration::isImportOnDemand));
            int pushed = 0;
            pushed += this.pushOnStack(this.f.importsOnDemand(this.top(), (Collection)isImportOnDemand.get(true)));
            pushed += this.pushOnStack(this.f.javaLangSymTable(this.top()));
            pushed += this.pushOnStack(this.f.samePackageSymTable(this.top()));
            pushed += this.pushOnStack(this.f.singleImportsSymbolTable(this.top(), (Collection)isImportOnDemand.get(false)));
            NodeStream<ASTAnyTypeDeclaration> typeDecls = node.getTypeDeclarations();
            pushed += this.pushOnStack(this.f.typesInFile(this.top(), typeDecls));
            this.setTopSymbolTable(node);
            for (ASTAnyTypeDeclaration td : typeDecls) {
                this.processTypeHeader(td, ctx);
            }
            this.visitChildren((Node)node, ctx);
            this.popStack(pushed);
            return null;
        }

        private void processTypeHeader(ASTAnyTypeDeclaration node, ReferenceCtx ctx) {
            this.setTopSymbolTable(node.getModifiers());
            int pushed = this.pushOnStack(this.f.selfType(this.top(), node.getTypeMirror()));
            pushed += this.pushOnStack(this.f.typeHeader(this.top(), node.getSymbol()));
            NodeStream notBody = node.children().drop(1).dropLast(1);
            for (JavaNode it : notBody) {
                this.setTopSymbolTable(it);
            }
            this.popStack(pushed - 1);
            this.f.disambig((NodeStream<? extends JavaNode>)notBody, ctx);
            this.setTopSymbolTable(node);
            this.popStack();
        }

        @Override
        public Void visitTypeDecl(ASTAnyTypeDeclaration node, @NonNull ReferenceCtx ctx) {
            int pushed = 0;
            this.enclosingType.push(node);
            ReferenceCtx bodyCtx = ctx.scopeDownToNested(node.getSymbol());
            pushed += this.pushOnStack(this.f.typeBody(this.top(), node.getTypeMirror()));
            this.setTopSymbolTable(node.getBody());
            node.getDeclarations(ASTAnyTypeDeclaration.class).forEach(d -> this.processTypeHeader((ASTAnyTypeDeclaration)d, bodyCtx));
            this.f.disambig((NodeStream<? extends JavaNode>)node.getDeclarations(ASTFieldDeclaration.class).map(ASTFieldDeclaration::getTypeNode), bodyCtx);
            this.visitChildren((Node)node.getBody(), bodyCtx);
            this.enclosingType.pop();
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTAnonymousClassDeclaration node, @NonNull ReferenceCtx ctx) {
            DeferredNode deferredSpec;
            if (node.getParent() instanceof ASTConstructorCall && !this.deferredInPrevRound.contains(deferredSpec = new DeferredNode(node, ctx, this.top()))) {
                this.newDeferred.add(deferredSpec);
                return null;
            }
            return this.visitTypeDecl((ASTAnyTypeDeclaration)node, ctx);
        }

        @Override
        public Void visitMethodOrCtor(ASTMethodOrConstructorDeclaration node, @NonNull ReferenceCtx ctx) {
            this.setTopSymbolTable(node.getModifiers());
            int pushed = this.pushOnStack(this.f.bodyDeclaration(this.top(), this.enclosing(), node.getFormalParameters(), node.getTypeParameters()));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTInitializer node, @NonNull ReferenceCtx ctx) {
            int pushed = this.pushOnStack(this.f.bodyDeclaration(this.top(), this.enclosing(), null, null));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTCompactConstructorDeclaration node, @NonNull ReferenceCtx ctx) {
            this.setTopSymbolTable(node.getModifiers());
            int pushed = this.pushOnStack(this.f.recordCtor(this.top(), this.enclosing(), node.getSymbol()));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTLambdaExpression node, @NonNull ReferenceCtx ctx) {
            int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableDeclaratorId>)MyVisitor.formalsOf(node)));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTBlock node, @NonNull ReferenceCtx ctx) {
            int pushed = this.visitBlockLike(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTSwitchStatement node, @NonNull ReferenceCtx ctx) {
            return this.visitSwitch(node, ctx);
        }

        @Override
        public Void visit(ASTSwitchExpression node, @NonNull ReferenceCtx ctx) {
            return this.visitSwitch(node, ctx);
        }

        private Void visitSwitch(ASTSwitchLike node, @NonNull ReferenceCtx ctx) {
            this.setTopSymbolTable(node);
            node.getTestedExpression().acceptVisitor(this, ctx);
            int pushed = 0;
            for (ASTSwitchBranch branch : node.getBranches()) {
                ASTSwitchLabel label = branch.getLabel();
                PatternBindingsUtil.BindSet bindings = (PatternBindingsUtil.BindSet)label.getExprList().reduce((Object)PatternBindingsUtil.BindSet.EMPTY, (bindSet, expr) -> bindSet.union(PatternBindingsUtil.bindersOfExpr(expr)));
                this.setTopSymbolTableAndVisit(label, ctx);
                if (branch instanceof ASTSwitchArrowBranch) {
                    pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableDeclaratorId>)bindings.getTrueBindings()));
                    this.setTopSymbolTableAndVisit(((ASTSwitchArrowBranch)branch).getRightHandSide(), ctx);
                    this.popStack(pushed);
                    pushed = 0;
                    continue;
                }
                if (!(branch instanceof ASTSwitchFallthroughBranch)) continue;
                pushed += this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableDeclaratorId>)bindings.getTrueBindings()));
                pushed += this.visitBlockLike((Iterable<? extends ASTStatement>)((ASTSwitchFallthroughBranch)branch).getStatements(), ctx);
            }
            this.popStack(pushed);
            return null;
        }

        private int visitBlockLike(Iterable<? extends ASTStatement> node, @NonNull ReferenceCtx ctx) {
            int pushed = 0;
            for (ASTStatement aSTStatement : node) {
                if (aSTStatement instanceof ASTLocalVariableDeclaration) {
                    pushed += this.processLocalVarDecl((ASTLocalVariableDeclaration)aSTStatement, ctx);
                } else if (aSTStatement instanceof ASTLocalClassStatement) {
                    ASTAnyTypeDeclaration local = ((ASTLocalClassStatement)aSTStatement).getDeclaration();
                    pushed += this.pushOnStack(this.f.localTypeSymTable(this.top(), local.getTypeMirror()));
                    this.processTypeHeader(local, ctx);
                }
                this.setTopSymbolTable(aSTStatement);
                PSet newVars = (PSet)aSTStatement.acceptVisitor(this.stmtVisitor, ctx);
                pushed += this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableDeclaratorId>)newVars));
            }
            return pushed;
        }

        private int processLocalVarDecl(ASTLocalVariableDeclaration st, @NonNull ReferenceCtx ctx) {
            int pushed = 0;
            for (ASTVariableDeclarator declarator : st.children(ASTVariableDeclarator.class)) {
                ASTVariableDeclaratorId varId = declarator.getVarId();
                pushed += this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (JVariableSymbol)varId.getSymbol()));
                this.setTopSymbolTableAndVisit(declarator.getInitializer(), ctx);
            }
            return pushed;
        }

        @Override
        public Void visit(ASTForeachStatement node, @NonNull ReferenceCtx ctx) {
            this.setTopSymbolTableAndVisit(node.getIterableExpr(), ctx);
            ASTVariableDeclaratorId varId = node.getVarId();
            this.setTopSymbolTableAndVisit(varId.getTypeNode(), ctx);
            int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (JVariableSymbol)varId.getSymbol()));
            ASTStatement body = node.getBody();
            this.setTopSymbolTableAndVisit(body, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTTryStatement node, @NonNull ReferenceCtx ctx) {
            ASTResourceList resources = node.getResources();
            if (resources != null) {
                NodeStream union = NodeStream.union((NodeStream[])new NodeStream[]{MyVisitor.stmtsOfResources(resources), NodeStream.of((Node)node.getBody())});
                this.popStack(this.visitBlockLike((Iterable<? extends ASTStatement>)union, ctx));
                for (Node child : node.getBody().asStream().followingSiblings()) {
                    child.acceptVisitor((AstVisitor)this, (Object)ctx);
                }
            } else {
                this.visitChildren((Node)node, ctx);
            }
            return null;
        }

        @Override
        public Void visit(ASTCatchClause node, @NonNull ReferenceCtx ctx) {
            int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (JVariableSymbol)node.getParameter().getVarId().getSymbol()));
            this.setTopSymbolTableAndVisitAllChildren(node, ctx);
            this.popStack(pushed);
            return null;
        }

        @Override
        public Void visit(ASTInfixExpression node, @NonNull ReferenceCtx ctx) {
            PSet<ASTVariableDeclaratorId> falseBindings;
            node.getLeftOperand().acceptVisitor(this, ctx);
            BinaryOp op = node.getOperator();
            if (op == BinaryOp.CONDITIONAL_AND) {
                PSet<ASTVariableDeclaratorId> trueBindings = PatternBindingsUtil.bindersOfExpr(node.getLeftOperand()).getTrueBindings();
                if (!trueBindings.isEmpty()) {
                    int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableDeclaratorId>)trueBindings));
                    this.setTopSymbolTableAndVisit(node.getRightOperand(), ctx);
                    this.popStack(pushed);
                    return null;
                }
            } else if (op == BinaryOp.CONDITIONAL_OR && !(falseBindings = PatternBindingsUtil.bindersOfExpr(node.getLeftOperand()).getFalseBindings()).isEmpty()) {
                int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableDeclaratorId>)falseBindings));
                this.setTopSymbolTableAndVisit(node.getRightOperand(), ctx);
                this.popStack(pushed);
                return null;
            }
            return (Void)node.getRightOperand().acceptVisitor(this, ctx);
        }

        @Override
        public Void visit(ASTConditionalExpression node, @NonNull ReferenceCtx ctx) {
            ASTExpression condition = node.getCondition();
            condition.acceptVisitor(this, ctx);
            PatternBindingsUtil.BindSet binders = PatternBindingsUtil.bindersOfExpr(condition);
            if (binders.isEmpty()) {
                node.getThenBranch().acceptVisitor(this, ctx);
                node.getElseBranch().acceptVisitor(this, ctx);
            } else {
                int pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableDeclaratorId>)binders.getTrueBindings()));
                this.setTopSymbolTableAndVisit(node.getThenBranch(), ctx);
                this.popStack(pushed);
                pushed = this.pushOnStack(this.f.localVarSymTable(this.top(), this.enclosing(), (Iterable<ASTVariableDeclaratorId>)binders.getFalseBindings()));
                this.setTopSymbolTableAndVisit(node.getElseBranch(), ctx);
                this.popStack(pushed);
            }
            return null;
        }

        private void setTopSymbolTable(JavaNode node) {
            InternalApiBridge.setSymbolTable(node, this.top());
        }

        private JClassType enclosing() {
            if (this.enclosingType.isEmpty()) {
                return null;
            }
            return this.enclosingType.getFirst().getTypeMirror();
        }

        private void setTopSymbolTableAndVisitAllChildren(JavaNode node, @NonNull ReferenceCtx ctx) {
            if (node == null) {
                return;
            }
            this.setTopSymbolTable(node);
            this.visitChildren((Node)node, ctx);
        }

        private void setTopSymbolTableAndVisit(JavaNode node, @NonNull ReferenceCtx ctx) {
            if (node == null) {
                return;
            }
            this.setTopSymbolTable(node);
            node.acceptVisitor(this, ctx);
        }

        private int pushOnStack(JSymbolTable table) {
            if (table == this.top()) {
                return 0;
            }
            this.stack.push(table);
            return 1;
        }

        private JSymbolTable popStack() {
            return this.stack.pop();
        }

        private void popStack(int times) {
            assert (this.stack.size() > times) : "Stack is too small (" + times + ") " + this.stack;
            while (times-- > 0) {
                this.popStack();
            }
        }

        private JSymbolTable top() {
            return this.stack.getFirst();
        }

        static NodeStream<ASTLocalVariableDeclaration> stmtsOfResources(ASTResourceList node) {
            return node.toStream().map(ASTResource::asLocalVariableDeclaration);
        }

        static NodeStream<ASTVariableDeclaratorId> formalsOf(ASTLambdaExpression node) {
            return node.getParameters().toStream().map(ASTLambdaParameter::getVarId);
        }

        class StatementVisitor
        extends JavaVisitorBase<ReferenceCtx, PSet<ASTVariableDeclaratorId>> {
            StatementVisitor() {
            }

            @Override
            public PSet<ASTVariableDeclaratorId> visitJavaNode(JavaNode node, ReferenceCtx ctx) {
                throw new IllegalStateException("I only expect statements, got " + node);
            }

            @Override
            public PSet<ASTVariableDeclaratorId> visitStatement(ASTStatement node, ReferenceCtx ctx) {
                node.acceptVisitor(MyVisitor.this, ctx);
                return PatternBindingsUtil.BindSet.noBindings();
            }

            @Override
            public PSet<ASTVariableDeclaratorId> visit(ASTLabeledStatement node, @NonNull ReferenceCtx ctx) {
                return (PSet)node.getStatement().acceptVisitor(this, ctx);
            }

            @Override
            public PSet<ASTVariableDeclaratorId> visit(ASTIfStatement node, ReferenceCtx ctx) {
                PatternBindingsUtil.BindSet bindSet = PatternBindingsUtil.bindersOfExpr(node.getCondition());
                ASTStatement thenBranch = node.getThenBranch();
                ASTStatement elseBranch = node.getElseBranch();
                MyVisitor.this.setTopSymbolTableAndVisit(node.getCondition(), ctx);
                int pushed = MyVisitor.this.pushOnStack(MyVisitor.this.f.localVarSymTable(MyVisitor.this.top(), MyVisitor.this.enclosing(), (Iterable<ASTVariableDeclaratorId>)bindSet.getTrueBindings()));
                this.setTopSymbolTableAndVisit(thenBranch, ctx);
                MyVisitor.this.popStack(pushed);
                if (elseBranch != null) {
                    pushed = MyVisitor.this.pushOnStack(MyVisitor.this.f.localVarSymTable(MyVisitor.this.top(), MyVisitor.this.enclosing(), (Iterable<ASTVariableDeclaratorId>)bindSet.getFalseBindings()));
                    this.setTopSymbolTableAndVisit(elseBranch, ctx);
                    MyVisitor.this.popStack(pushed);
                }
                if (!bindSet.isEmpty()) {
                    boolean elseCanCompleteNormally;
                    boolean thenCanCompleteNormally = AbruptCompletionAnalysis.canCompleteNormally(thenBranch);
                    boolean bl = elseCanCompleteNormally = elseBranch == null || AbruptCompletionAnalysis.canCompleteNormally(elseBranch);
                    if (thenCanCompleteNormally && !elseCanCompleteNormally) {
                        return bindSet.getTrueBindings();
                    }
                    if (!thenCanCompleteNormally && elseCanCompleteNormally) {
                        return bindSet.getFalseBindings();
                    }
                }
                return PatternBindingsUtil.BindSet.noBindings();
            }

            @Override
            public PSet<ASTVariableDeclaratorId> visit(ASTWhileStatement node, ReferenceCtx ctx) {
                PatternBindingsUtil.BindSet bindSet = PatternBindingsUtil.bindersOfExpr(node.getCondition());
                MyVisitor.this.setTopSymbolTableAndVisit(node.getCondition(), ctx);
                int pushed = MyVisitor.this.pushOnStack(MyVisitor.this.f.localVarSymTable(MyVisitor.this.top(), MyVisitor.this.enclosing(), (Iterable<ASTVariableDeclaratorId>)NodeStream.fromIterable(bindSet.getTrueBindings())));
                this.setTopSymbolTableAndVisit(node.getBody(), ctx);
                MyVisitor.this.popStack(pushed);
                if (this.hasNoBreakContainingStmt(node)) {
                    return bindSet.getFalseBindings();
                }
                return PatternBindingsUtil.BindSet.noBindings();
            }

            @Override
            public PSet<ASTVariableDeclaratorId> visit(ASTForStatement node, @NonNull ReferenceCtx ctx) {
                int pushed = 0;
                ASTStatement init = node.getInit();
                if (init instanceof ASTLocalVariableDeclaration) {
                    pushed += MyVisitor.this.processLocalVarDecl((ASTLocalVariableDeclaration)init, ctx);
                } else {
                    this.setTopSymbolTableAndVisit(init, ctx);
                }
                ASTExpression condition = node.getCondition();
                MyVisitor.this.setTopSymbolTableAndVisit(node.getCondition(), ctx);
                PatternBindingsUtil.BindSet bindSet = PatternBindingsUtil.bindersOfExpr(condition);
                this.setTopSymbolTableAndVisit(node.getUpdate(), ctx);
                this.setTopSymbolTableAndVisit(node.getBody(), ctx);
                MyVisitor.this.popStack(pushed += MyVisitor.this.pushOnStack(MyVisitor.this.f.localVarSymTable(MyVisitor.this.top(), MyVisitor.this.enclosing(), (Iterable<ASTVariableDeclaratorId>)bindSet.getTrueBindings())));
                if (bindSet.getFalseBindings().isEmpty()) {
                    return PatternBindingsUtil.BindSet.noBindings();
                }
                if (this.hasNoBreakContainingStmt(node)) {
                    return bindSet.getFalseBindings();
                }
                return PatternBindingsUtil.BindSet.noBindings();
            }

            private boolean hasNoBreakContainingStmt(ASTLoopStatement node) {
                Set containingStatements = (Set)node.ancestorsOrSelf().filter(JavaAstUtils::mayBeBreakTarget).collect(Collectors.toSet());
                return node.getBody().descendants(ASTBreakStatement.class).none(it -> containingStatements.contains(it.getTarget()));
            }

            private void setTopSymbolTableAndVisitAllChildren(JavaNode node, @NonNull ReferenceCtx ctx) {
                if (node == null) {
                    return;
                }
                MyVisitor.this.setTopSymbolTable(node);
                this.visitChildren((Node)node, ctx);
            }

            private void setTopSymbolTableAndVisit(JavaNode node, @NonNull ReferenceCtx ctx) {
                if (node == null) {
                    return;
                }
                MyVisitor.this.setTopSymbolTable(node);
                node.acceptVisitor(this, ctx);
            }
        }
    }

    private static final class DeferredNode {
        final JavaNode node;
        final ReferenceCtx enclosingCtx;
        final JSymbolTable localStackTop;

        private DeferredNode(JavaNode node, ReferenceCtx enclosingCtx, JSymbolTable localStackTop) {
            this.node = node;
            this.enclosingCtx = enclosingCtx;
            this.localStackTop = localStackTop;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeferredNode that = (DeferredNode)o;
            return this.node.equals(that.node);
        }

        public int hashCode() {
            return Objects.hash(this.node);
        }
    }
}

