/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class NonSerializableClassRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<String> PREFIX_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"prefix").desc("deprecated! A variable prefix to skip, i.e., m_")).defaultValue((Object)"")).build();
    private static final PropertyDescriptor<Boolean> CHECK_ABSTRACT_TYPES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkAbstractTypes").desc("Enable to verify fields with abstract types like abstract classes, interfaces, generic types or java.lang.Object. Enabling this might lead to more false positives, since the concrete runtime type can actually be serializable.")).defaultValue((Object)false)).build();
    private static final String SERIAL_PERSISTENT_FIELDS_TYPE = "java.io.ObjectStreamField[]";
    private static final String SERIAL_PERSISTENT_FIELDS_NAME = "serialPersistentFields";
    private Map<ASTAnyTypeDeclaration, Set<String>> cachedPersistentFieldNames;

    public NonSerializableClassRule() {
        super(ASTVariableDeclaratorId.class, ASTClassOrInterfaceDeclaration.class, ASTEnumDeclaration.class, ASTRecordDeclaration.class);
        this.definePropertyDescriptor(PREFIX_DESCRIPTOR);
        this.definePropertyDescriptor(CHECK_ABSTRACT_TYPES);
    }

    public void start(RuleContext ctx) {
        this.cachedPersistentFieldNames = new HashMap<ASTAnyTypeDeclaration, Set<String>>();
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.checkSerialPersistentFieldsField(node, data);
        return null;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.checkSerialPersistentFieldsField(node, data);
        return null;
    }

    @Override
    public Object visit(ASTRecordDeclaration node, Object data) {
        this.checkSerialPersistentFieldsField(node, data);
        return null;
    }

    private void checkSerialPersistentFieldsField(ASTAnyTypeDeclaration anyTypeDeclaration, Object data) {
        for (ASTFieldDeclaration field : anyTypeDeclaration.descendants(ASTFieldDeclaration.class)) {
            for (ASTVariableDeclaratorId varId : field) {
                if (!SERIAL_PERSISTENT_FIELDS_NAME.equals(varId.getName()) || TypeTestUtil.isA(SERIAL_PERSISTENT_FIELDS_TYPE, (TypeNode)varId) && field.getVisibility() == AccessNode.Visibility.V_PRIVATE && field.hasModifiers(JModifier.STATIC, new JModifier[0]) && field.hasModifiers(JModifier.FINAL, new JModifier[0])) continue;
                this.asCtx(data).addViolationWithMessage((Node)varId, "The field ''{0}'' should be private static final with type ''{1}''.", new Object[]{varId.getName(), SERIAL_PERSISTENT_FIELDS_TYPE});
            }
        }
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        ASTAnyTypeDeclaration typeDeclaration = (ASTAnyTypeDeclaration)node.ancestors(ASTAnyTypeDeclaration.class).first();
        if (typeDeclaration == null || !TypeTestUtil.isA(Serializable.class, (TypeNode)typeDeclaration) || TypeTestUtil.isA(Externalizable.class, (TypeNode)typeDeclaration) || this.hasManualSerializationMethod(typeDeclaration)) {
            return null;
        }
        if (this.isPersistentField(typeDeclaration, node) && this.isNotSerializable(node)) {
            this.asCtx(data).addViolation((Node)node, new Object[]{node.getName(), typeDeclaration.getBinaryName(), node.getTypeMirror()});
        }
        return null;
    }

    private boolean hasManualSerializationMethod(ASTAnyTypeDeclaration node) {
        boolean hasWriteObject = false;
        boolean hasReadObject = false;
        boolean hasWriteReplace = false;
        boolean hasReadResolve = false;
        for (ASTBodyDeclaration decl : node.getDeclarations().toList()) {
            if (!(decl instanceof ASTMethodDeclaration)) continue;
            ASTMethodDeclaration methodDeclaration = (ASTMethodDeclaration)decl;
            String methodName = methodDeclaration.getName();
            int parameterCount = methodDeclaration.getFormalParameters().size();
            ASTFormalParameter firstParameter = parameterCount > 0 ? (ASTFormalParameter)methodDeclaration.getFormalParameters().get(0) : null;
            ASTType resultType = methodDeclaration.getResultTypeNode();
            hasWriteObject |= "writeObject".equals(methodName) && parameterCount == 1 && TypeTestUtil.isA(ObjectOutputStream.class, (TypeNode)firstParameter) && resultType.isVoid();
            hasReadObject |= "readObject".equals(methodName) && parameterCount == 1 && TypeTestUtil.isA(ObjectInputStream.class, (TypeNode)firstParameter) && resultType.isVoid();
            hasWriteReplace |= "writeReplace".equals(methodName) && parameterCount == 0 && TypeTestUtil.isExactlyA(Object.class, (TypeNode)resultType);
            hasReadResolve |= "readResolve".equals(methodName) && parameterCount == 0 && TypeTestUtil.isExactlyA(Object.class, (TypeNode)resultType);
        }
        return hasWriteObject && hasReadObject || hasWriteReplace && hasReadResolve;
    }

    private boolean isNotSerializable(TypeNode node) {
        boolean notSerializable;
        JTypeMirror typeMirror = node.getTypeMirror();
        JTypeDeclSymbol typeSymbol = typeMirror.getSymbol();
        JClassSymbol classSymbol = null;
        if (typeSymbol instanceof JClassSymbol) {
            classSymbol = (JClassSymbol)typeSymbol;
        }
        boolean bl = notSerializable = !TypeTestUtil.isA(Serializable.class, node) && !typeMirror.isPrimitive();
        if (!((Boolean)this.getProperty(CHECK_ABSTRACT_TYPES)).booleanValue() && classSymbol != null) {
            notSerializable &= !TypeTestUtil.isExactlyA(Object.class, node) && !classSymbol.isInterface() && !classSymbol.isAbstract();
        }
        if (!((Boolean)this.getProperty(CHECK_ABSTRACT_TYPES)).booleanValue() && typeMirror instanceof JTypeVar) {
            notSerializable = false;
        }
        if (typeSymbol != null && typeSymbol.isUnresolved()) {
            notSerializable = false;
        }
        return notSerializable;
    }

    private Set<String> determinePersistentFields(ASTAnyTypeDeclaration typeDeclaration) {
        ASTExpression initializer;
        if (this.cachedPersistentFieldNames.containsKey(typeDeclaration)) {
            return this.cachedPersistentFieldNames.get(typeDeclaration);
        }
        ASTVariableDeclarator persistentFieldsDecl = null;
        for (ASTFieldDeclaration field : typeDeclaration.descendants(ASTFieldDeclaration.class)) {
            if (field.getVisibility() != AccessNode.Visibility.V_PRIVATE || !field.hasModifiers(JModifier.STATIC, new JModifier[]{JModifier.FINAL})) continue;
            for (ASTVariableDeclaratorId varId : field) {
                if (!TypeTestUtil.isA(SERIAL_PERSISTENT_FIELDS_TYPE, (TypeNode)varId) || !SERIAL_PERSISTENT_FIELDS_NAME.equals(varId.getName())) continue;
                persistentFieldsDecl = (ASTVariableDeclarator)varId.ancestors(ASTVariableDeclarator.class).first();
            }
        }
        Set fields = null;
        if (persistentFieldsDecl != null && (fields = persistentFieldsDecl.descendants(ASTStringLiteral.class).toStream().map(ASTStringLiteral::getConstValue).collect(Collectors.toSet())).isEmpty() && (initializer = persistentFieldsDecl.getInitializer()) instanceof ASTVariableAccess) {
            ASTVariableAccess variableAccess = (ASTVariableAccess)initializer;
            ASTVariableDeclaratorId reference = (ASTVariableDeclaratorId)variableAccess.getReferencedSym().tryGetNode();
            fields = ((JavaNode)reference.getParent()).descendants(ASTStringLiteral.class).toStream().map(ASTStringLiteral::getConstValue).collect(Collectors.toSet());
        }
        this.cachedPersistentFieldNames.put(typeDeclaration, fields);
        return fields;
    }

    private boolean isPersistentField(ASTAnyTypeDeclaration typeDeclaration, ASTVariableDeclaratorId node) {
        Set<String> persistentFields = this.determinePersistentFields(typeDeclaration);
        if (node.isField() && (persistentFields == null || persistentFields.contains(node.getName()))) {
            ASTFieldDeclaration field = (ASTFieldDeclaration)node.ancestors(ASTFieldDeclaration.class).first();
            return field != null && !field.hasModifiers(JModifier.STATIC, new JModifier[0]) && !field.hasModifiers(JModifier.TRANSIENT, new JModifier[0]);
        }
        return false;
    }
}

