/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTEmptyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTResourceList;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;

public class EmptyControlStatementRule
extends AbstractJavaRulechainRule {
    public EmptyControlStatementRule() {
        super(ASTFinallyClause.class, ASTSynchronizedStatement.class, ASTTryStatement.class, ASTDoStatement.class, ASTBlock.class, ASTForStatement.class, ASTForeachStatement.class, ASTWhileStatement.class, ASTIfStatement.class, ASTSwitchStatement.class, ASTInitializer.class);
    }

    @Override
    public Object visit(ASTFinallyClause node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty finally clause");
        }
        return null;
    }

    @Override
    public Object visit(ASTSynchronizedStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty synchronized statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        if (node.getNumChildren() == 1) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty switch statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTBlock node, Object data) {
        if (this.isEmpty(node) && node.getParent() instanceof ASTBlock) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty block");
        }
        return null;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        if (this.isEmpty(node.getThenBranch())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty if statement");
        }
        if (node.hasElse() && this.isEmpty(node.getElseBranch())) {
            this.asCtx(data).addViolationWithMessage((Node)node.getElseBranch(), "Empty else statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty while statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty for statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTForeachStatement node, Object data) {
        if (JavaRuleUtil.isExplicitUnusedVarName(node.getVarId().getName())) {
            return null;
        }
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty foreach statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty do..while statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTInitializer node, Object data) {
        if (this.isEmpty(node.getBody())) {
            this.asCtx(data).addViolationWithMessage((Node)node, "Empty initializer statement");
        }
        return null;
    }

    @Override
    public Object visit(ASTTryStatement node, Object data) {
        if (this.isEmpty(node.getBody())) {
            boolean allResourcesIgnored = true;
            boolean hasResource = false;
            ASTResourceList resources = node.getResources();
            if (resources != null) {
                for (ASTResource resource : resources) {
                    hasResource = true;
                    String name = resource.getStableName();
                    if (JavaRuleUtil.isExplicitUnusedVarName(name)) continue;
                    allResourcesIgnored = false;
                    break;
                }
            }
            if (hasResource && !allResourcesIgnored) {
                this.asCtx(data).addViolationWithMessage((Node)node, "Empty try body - you could rename the resource to ''ignored''");
            } else if (!hasResource) {
                this.asCtx(data).addViolationWithMessage((Node)node, "Empty try body");
            }
        }
        return null;
    }

    private boolean isEmpty(JavaNode node) {
        return node instanceof ASTBlock && node.getNumChildren() == 0 || node instanceof ASTEmptyStatement;
    }
}

